/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.webkit.JavascriptInterface;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class JavascriptAgentInterface {
    private static final String LOGTAG = Global.LOG_PREFIX + "JavascriptAgentInterface";

    @JavascriptInterface
    public void incrementActionCount() {
        if (Dynatrace.getCaptureStatus()) {
            Session.determineActiveSession(false, true);
        }
    }

    @JavascriptInterface
    public String getUserPrivacyOptions() {
        JSONObject jsonObject = new JSONObject();
        UserPrivacyOptions options = Session.currentSession().getPrivacyRules().getPrivacySettings();
        try {
            jsonObject.put("dataCollectionLevel", options.getDataCollectionLevel().getJavaScriptValue());
            jsonObject.put("crashReportingOptedIn", options.isCrashReportingOptedIn());
            return jsonObject.toString();
        }
        catch (JSONException e) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "Exception while creating JSON object for UserPrivacyOptions: " + e.getMessage());
            }
            return "";
        }
    }

    @JavascriptInterface
    public void applyUserPrivacyOptions(int dataCollectionLevel, boolean crashReportingOptedIn) {
        DataCollectionLevel level = DataCollectionLevel.castJavaScriptValue(dataCollectionLevel);
        UserPrivacyOptions optionsNew = new UserPrivacyOptions.Builder().withCrashReportingOptedIn(crashReportingOptedIn).withDataCollectionLevel(level).build();
        Dynatrace.applyUserPrivacyOptions(optionsNew);
    }
}

