/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class ErrorSegment
extends CustomSegment {
    protected String exceptionName;
    protected String reason;
    protected String stacktrace;
    protected String platformType;

    protected ErrorSegment(String name, String exceptionName, String reason, String stacktrace, long parentTagId, Session session, int serverId, String platformType) {
        this(name, 6, EventType.ERROR_EXCEPTION, exceptionName, reason, stacktrace, parentTagId, session, serverId, platformType);
    }

    protected ErrorSegment(String name, int type, EventType eventType, String exceptionName, String reason, String stacktrace, long parentTagId, Session session, int serverId, String platformType) {
        super(name, type, eventType, parentTagId, session, serverId);
        this.exceptionName = exceptionName;
        this.reason = reason;
        this.stacktrace = stacktrace;
        this.platformType = platformType;
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode(this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.getLcSeqNum());
        sb.append("&t0=").append(this.getStartTime());
        this.appendOptionalValue(sb, "&rs=", Utility.urlEncode(this.reason));
        this.appendOptionalValue(sb, "&ev=", Utility.urlEncode(this.exceptionName));
        this.appendOptionalValue(sb, "&st=", Utility.urlEncode(this.stacktrace));
        sb.append("&tt=").append(this.platformType);
        return sb;
    }
}

