/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.WebReqSegment;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.ConnStateParms;
import com.dynatrace.android.callback.WebReqStateParms;

final class CbWebReqTracker {
    private static final String LOGTAG = "caa-aCbWebReqTracker";
    DTXAutoAction action;
    Session session;
    boolean canFinalize;
    WebReqStateParms stateParm;
    WebReqTag webReqTag;
    long startTime;
    private long endTime;
    private String server;
    private long requestLength = -1L;
    private long responseLength = -1L;
    private CustomSegment wrtEvent;
    private String eventData;

    CbWebReqTracker(DTXAutoAction action, Session session) {
        this.action = action;
        this.session = session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.canFinalize)).append('&').append('&');
        sb.append(String.valueOf(this.startTime)).append('&').append('&');
        sb.append(String.valueOf(this.endTime)).append('&').append('&');
        sb.append(String.valueOf(this.server)).append('&').append('&');
        if (this.webReqTag != null) {
            sb.append(this.webReqTag.toString()).append('&').append('&');
        } else {
            sb.append("NA").append('&').append('&');
        }
        if (this.action != null) {
            sb.append(this.action.createEventData().toString()).append('&').append('&');
        } else {
            sb.append("NA").append('&').append('&');
        }
        if (this.wrtEvent != null) {
            sb.append(this.eventData);
        } else {
            sb.append("NA");
        }
        return sb.toString();
    }

    void procNewState(WebReqStateParms parm) {
        if (this.server == null) {
            this.server = parm.getRequestHost();
        }
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)(parm.getRequestMethod() + "/" + (Object)((Object)parm.trackingMethod) + "/" + (Object)((Object)parm.state)));
        }
        switch (parm.state) {
            case PRE_EXEC: {
                if (this.startTime <= 0L) {
                    this.startTime = this.session.getRunningTime();
                }
                if (this.requestLength >= 0L) {
                    parm.requestLength = this.requestLength;
                } else if (parm instanceof ConnStateParms) {
                    ((ConnStateParms)parm).calcRequestBytes(parm.trackingMethod == CbConstants.WrMethod.getOutputStream);
                }
                if (this.responseLength < 0L) break;
                parm.responseLength = this.responseLength;
                break;
            }
            case POST_EXEC_ERR: {
                if (parm.requestLength >= 0L) {
                    this.requestLength = parm.requestLength;
                }
                if (parm.responseLength >= 0L) {
                    this.responseLength = parm.responseLength;
                }
                if (parm.trackingMethod == CbConstants.WrMethod.getOutputStream && this.endTime > 0L) {
                    this.endTime = 0L;
                    break;
                }
                this.canFinalize = true;
                this.endTime = this.session.getRunningTime();
                break;
            }
            case POST_EXEC_OK: {
                if (parm instanceof ConnStateParms && parm.trackingMethod != CbConstants.WrMethod.getOutputStream) {
                    ConnStateParms connStateParms = (ConnStateParms)parm;
                    connStateParms.calcResponseBytes();
                    connStateParms.evaluateServerTiming();
                }
                if (parm.requestLength >= 0L) {
                    this.requestLength = parm.requestLength;
                }
                if (parm.responseLength >= 0L) {
                    this.responseLength = parm.responseLength;
                }
                if (parm.trackingMethod == CbConstants.WrMethod.getOutputStream) {
                    this.endTime = this.session.getRunningTime();
                    break;
                }
                this.canFinalize = parm.canFinalize;
                if (this.endTime > 0L) break;
                this.endTime = this.session.getRunningTime();
                break;
            }
            case POST_EXEC_FINALIZE: {
                parm.canFinalize = true;
                this.canFinalize = true;
                if (this.endTime > 0L) break;
                this.endTime = this.session.getRunningTime();
                break;
            }
        }
    }

    void setWebReqTag(WebReqTag webReqTag) {
        this.webReqTag = webReqTag;
    }

    void checkForManualTag(String webReqTag) {
        if (this.webReqTag == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("ManualTag '%s' is used", webReqTag));
            }
            return;
        }
        if (!this.webReqTag.sameAs(webReqTag)) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)String.format("AutoTag %s != ManualTag '%s'", this.webReqTag.toString(), webReqTag));
            }
            if (this.action != null) {
                this.action.removeChildEvent(this.webReqTag.toString());
            }
            this.webReqTag = null;
        }
    }

    void sendEvents(WebReqStateParms parm) {
        if (Global.DEBUG) {
            String tag = this.webReqTag != null ? this.webReqTag.toString() : "none!";
            Utility.zlogD((String)LOGTAG, (String)String.format("WRE: sT=%d eT=%d server=%s tag=%s", this.startTime, this.endTime, this.server, tag));
            Utility.zlogD((String)LOGTAG, (String)String.format("WRE: desc=%s rc=%d msg=%s", parm.getRequestDesc(), parm.respCode, parm.reason));
        }
        String reqDesc = parm.getRequestDesc();
        if (Dynatrace.getCaptureStatus() && this.webReqTag != null) {
            WebReqSegment event = new WebReqSegment(this.webReqTag.getParentTagId(), this.webReqTag.getSeqNumber(), this.startTime, this.endTime, parm.respCode, parm.reason, reqDesc, parm.requestLength, parm.responseLength, this.session, this.webReqTag.getServerId(), parm.serverTimingValue);
            if (CallbackCore.captureTestData) {
                this.wrtEvent = event;
                this.eventData = event.createEventData().toString();
            }
            Core.saveSegment((CustomSegment)event);
        }
        if (this.action != null && this.webReqTag != null) {
            this.action.onWrFinished(this.webReqTag.getParentTagId());
        }
    }
}

