/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.util;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsProperties;
import com.dynatrace.agent.userinteraction.model.DTBasicTextModifier;
import com.dynatrace.agent.userinteraction.model.DTUserInteractionsModifier;
import com.dynatrace.agent.userinteraction.model.TouchAction;
import com.dynatrace.agent.userinteraction.util.UserInteractionUtilKt$getRole$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0000\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\u0011H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0002*\u00020\u0011H\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0002*\u00020\u0011H\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0002*\u00020\u0011H\u0000\u001a\f\u0010\u0018\u001a\u00020\f*\u00020\u0011H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"CLICKABLE_MODIFIER_NAMES", "", "", "getCLICKABLE_MODIFIER_NAMES", "()Ljava/util/Set;", "findTopView", "Landroid/view/View;", "Landroid/view/ViewGroup;", "x", "", "y", "isPointInBounds", "", "getActionName", "Lcom/dynatrace/agent/userinteraction/model/TouchAction;", "Landroid/view/MotionEvent;", "getCustomId", "Landroidx/compose/ui/layout/LayoutInfo;", "getArea", "Landroidx/compose/ui/geometry/Rect;", "isValid", "getCustomName", "getText", "getRole", "isClickable", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nUserInteractionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserInteractionUtil.kt\ncom/dynatrace/agent/userinteraction/util/UserInteractionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n808#2,11:131\n295#2,2:142\n1557#2:144\n1628#2,3:145\n808#2,11:148\n295#2,2:159\n295#2,2:161\n1755#2,2:164\n1755#2,3:166\n1757#2:169\n477#3:163\n*S KotlinDebug\n*F\n+ 1 UserInteractionUtil.kt\ncom/dynatrace/agent/userinteraction/util/UserInteractionUtilKt\n*L\n62#1:127\n62#1:128,3\n63#1:131,11\n64#1:142,2\n78#1:144\n78#1:145,3\n81#1:148,11\n82#1:159,2\n90#1:161,2\n121#1:164,2\n123#1:166,3\n121#1:169\n102#1:163\n*E\n"})
public final class UserInteractionUtilKt {
    @NotNull
    private static final Set<String> CLICKABLE_MODIFIER_NAMES;

    @NotNull
    public static final Set<String> getCLICKABLE_MODIFIER_NAMES() {
        return CLICKABLE_MODIFIER_NAMES;
    }

    @NotNull
    public static final View findTopView(@NotNull ViewGroup $this$findTopView, int x, int y) {
        View view;
        Intrinsics.checkNotNullParameter((Object)$this$findTopView, (String)"<this>");
        if (!UserInteractionUtilKt.isPointInBounds((View)$this$findTopView, x, y)) {
            return (View)$this$findTopView;
        }
        View topView = null;
        for (int i = $this$findTopView.getChildCount() - 1; -1 < i; --i) {
            View child = $this$findTopView.getChildAt(i);
            Intrinsics.checkNotNull((Object)child);
            if (!UserInteractionUtilKt.isPointInBounds(child, x, y)) continue;
            topView = child instanceof ViewGroup ? UserInteractionUtilKt.findTopView((ViewGroup)child, x, y) : child;
            break;
        }
        if ((view = topView) == null) {
            view = (View)$this$findTopView;
        }
        return view;
    }

    private static final boolean isPointInBounds(View $this$isPointInBounds, int x, int y) {
        int[] location = new int[2];
        $this$isPointInBounds.getLocationOnScreen(location);
        int viewX = location[0];
        int viewY = location[1];
        return x >= viewX && x <= viewX + $this$isPointInBounds.getWidth() && y >= viewY && y <= viewY + $this$isPointInBounds.getHeight();
    }

    @NotNull
    public static final TouchAction getActionName(@NotNull MotionEvent $this$getActionName) {
        TouchAction touchAction;
        Intrinsics.checkNotNullParameter((Object)$this$getActionName, (String)"<this>");
        switch ($this$getActionName.getAction()) {
            case 0: {
                touchAction = TouchAction.DOWN;
                break;
            }
            case 1: {
                touchAction = TouchAction.UP;
                break;
            }
            case 2: {
                touchAction = TouchAction.MOVE;
                break;
            }
            case 5: {
                touchAction = TouchAction.POINTER_DOWN;
                break;
            }
            case 6: {
                touchAction = TouchAction.POINTER_UP;
                break;
            }
            default: {
                touchAction = TouchAction.UNKNOWN;
            }
        }
        return touchAction;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getCustomId(@NotNull LayoutInfo $this$getCustomId) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getCustomId, (String)"<this>");
            Iterable $this$map$iv = $this$getCustomId.getModifierInfo();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModifierInfo modifierInfo = (ModifierInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getModifier());
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DTUserInteractionsModifier)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DTUserInteractionsModifier it = (DTUserInteractionsModifier)((Object)element$iv);
                boolean bl = false;
                if (!(it.getCustomId() != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        DTUserInteractionsModifier dTUserInteractionsModifier = v0;
        return dTUserInteractionsModifier != null ? dTUserInteractionsModifier.getCustomId() : null;
    }

    @NotNull
    public static final Rect getArea(@NotNull LayoutInfo $this$getArea) {
        Intrinsics.checkNotNullParameter((Object)$this$getArea, (String)"<this>");
        if (!UserInteractionUtilKt.isValid($this$getArea)) {
            return Rect.Companion.getZero();
        }
        return LayoutCoordinatesKt.boundsInWindow((LayoutCoordinates)$this$getArea.getCoordinates());
    }

    private static final boolean isValid(LayoutInfo $this$isValid) {
        return $this$isValid.isAttached() && $this$isValid.isPlaced() && $this$isValid.getWidth() > 0 && $this$isValid.getHeight() > 0 && $this$isValid.getCoordinates().isAttached();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getCustomName(@NotNull LayoutInfo $this$getCustomName) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getCustomName, (String)"<this>");
            Iterable $this$map$iv = $this$getCustomName.getModifierInfo();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ModifierInfo modifierInfo = (ModifierInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getModifier());
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DTUserInteractionsModifier)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DTUserInteractionsModifier it = (DTUserInteractionsModifier)((Object)element$iv);
                boolean bl = false;
                if (!(it.getCustomName() != null)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        DTUserInteractionsModifier dTUserInteractionsModifier = v0;
        return dTUserInteractionsModifier != null ? dTUserInteractionsModifier.getCustomName() : null;
    }

    @Nullable
    public static final String getText(@NotNull LayoutInfo $this$getText) {
        String string;
        ModifierInfo textModifier;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
            if ($this$getText.getModifierInfo().isEmpty()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = $this$getText.getModifierInfo();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ModifierInfo it = (ModifierInfo)element$iv;
                boolean bl = false;
                if (!(it.getModifier() instanceof DTBasicTextModifier)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        ModifierInfo modifierInfo = textModifier = (ModifierInfo)v0;
        if (modifierInfo != null) {
            ModifierInfo it = modifierInfo;
            boolean bl = false;
            Modifier modifier = textModifier.getModifier();
            Intrinsics.checkNotNull((Object)modifier, (String)"null cannot be cast to non-null type com.dynatrace.agent.userinteraction.model.DTBasicTextModifier");
            string = ((DTBasicTextModifier)modifier).getText();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getRole(@NotNull LayoutInfo $this$getRole) {
        Intrinsics.checkNotNullParameter((Object)$this$getRole, (String)"<this>");
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$getRole.getModifierInfo()), UserInteractionUtilKt::getRole$lambda$6);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getRole$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        String role = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, UserInteractionUtilKt::getRole$lambda$7), UserInteractionUtilKt::getRole$lambda$8));
        return role != null ? role : (UserInteractionUtilKt.getText($this$getRole) != null ? "Text" : null);
    }

    public static final boolean isClickable(@NotNull LayoutInfo $this$isClickable) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$isClickable, (String)"<this>");
            Iterable $this$any$iv = $this$isClickable.getModifierInfo();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        ModifierInfo modifierInfo = (ModifierInfo)element$iv;
                        boolean bl3 = false;
                        String modifierString = modifierInfo.getModifier().toString();
                        Iterable $this$any$iv2 = CLICKABLE_MODIFIER_NAMES;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl4 = false;
                                if (!StringsKt.contains$default((CharSequence)modifierString, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Modifier getRole$lambda$6(ModifierInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModifier();
    }

    private static final boolean getRole$lambda$7(SemanticsModifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSemanticsConfiguration().contains(SemanticsProperties.INSTANCE.getRole());
    }

    private static final String getRole$lambda$8(SemanticsModifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Role.toString-impl((int)((Role)it.getSemanticsConfiguration().get(SemanticsProperties.INSTANCE.getRole())).unbox-impl());
    }

    static {
        Object[] objectArray = new String[]{"androidx.compose.foundation.ClickableElement", "androidx.compose.foundation.CombinedClickableElement"};
        CLICKABLE_MODIFIER_NAMES = SetsKt.setOf((Object[])objectArray);
    }
}

