/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.storage.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.dynatrace.agent.storage.db.EventDao;
import com.dynatrace.agent.storage.db.EventMetadata;
import com.dynatrace.agent.storage.db.EventRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class EventDao_Impl
implements EventDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EventRecord> __insertionAdapterOfEventRecord;
    private final EntityDeletionOrUpdateAdapter<EventRecord> __deletionAdapterOfEventRecord;
    private final SharedSQLiteStatement __preparedStmtOfDeleteOutdated;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EventDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEventRecord = new EntityInsertionAdapter<EventRecord>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `events` (`id`,`event`,`timestamp`,`isPriorityData`,`eventSizeBytes`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull EventRecord entity) {
                statement.bindLong(1, entity.getId());
                statement.bindString(2, entity.getEvent());
                statement.bindLong(3, entity.getTimestamp());
                int _tmp = entity.isPriorityData() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, (long)entity.getEventSizeBytes());
            }
        };
        this.__deletionAdapterOfEventRecord = new EntityDeletionOrUpdateAdapter<EventRecord>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `events` WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull EventRecord entity) {
                statement.bindLong(1, entity.getId());
            }
        };
        this.__preparedStmtOfDeleteOutdated = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM events WHERE ? < ? - timestamp";
                return "DELETE FROM events WHERE ? < ? - timestamp";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM events";
                return "DELETE FROM events";
            }
        };
    }

    @Override
    public Object put(final EventRecord eventRecord, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                EventDao_Impl.this.__db.beginTransaction();
                try {
                    EventDao_Impl.this.__insertionAdapterOfEventRecord.insert((Object)eventRecord);
                    EventDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object delete(final List<EventRecord> eventRecords, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                EventDao_Impl.this.__db.beginTransaction();
                try {
                    EventDao_Impl.this.__deletionAdapterOfEventRecord.handleMultiple((Iterable)eventRecords);
                    EventDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteOutdated(final long now, final long retentionTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EventDao_Impl.this.__preparedStmtOfDeleteOutdated.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, retentionTime);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, now);
                try {
                    Unit unit;
                    EventDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        EventDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        EventDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    EventDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    EventDao_Impl.this.__preparedStmtOfDeleteOutdated.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteAll(Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = EventDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                try {
                    Unit unit;
                    EventDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        EventDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        EventDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    EventDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    EventDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object getAll(Continuation<? super List<EventRecord>> $completion) {
        String _sql = "SELECT * FROM events";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM events", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<EventRecord>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<EventRecord> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfEvent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"event");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfIsPriorityData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPriorityData");
                    int _cursorIndexOfEventSizeBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventSizeBytes");
                    ArrayList<EventRecord> _result = new ArrayList<EventRecord>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpEvent = _cursor.getString(_cursorIndexOfEvent);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsPriorityData);
                        boolean _tmpIsPriorityData = _tmp != 0;
                        int _tmpEventSizeBytes = _cursor.getInt(_cursorIndexOfEventSizeBytes);
                        EventRecord _item = new EventRecord(_tmpId, _tmpEvent, _tmpTimestamp, _tmpIsPriorityData, _tmpEventSizeBytes);
                        _result.add(_item);
                    }
                    ArrayList<EventRecord> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object fetchEventMetadata(boolean isPriority, int limitRows, Continuation<? super List<EventMetadata>> $completion) {
        String _sql = "SELECT id, timestamp, isPriorityData, eventSizeBytes FROM events WHERE isPriorityData = ? LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, timestamp, isPriorityData, eventSizeBytes FROM events WHERE isPriorityData = ? LIMIT ?", (int)2);
        int _argIndex = 1;
        int _tmp = isPriority ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)limitRows);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<EventMetadata>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<EventMetadata> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    boolean _cursorIndexOfId = false;
                    boolean _cursorIndexOfTimestamp = true;
                    int _cursorIndexOfIsPriorityData = 2;
                    int _cursorIndexOfEventSizeBytes = 3;
                    ArrayList<EventMetadata> _result = new ArrayList<EventMetadata>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(0);
                        long _tmpTimestamp = _cursor.getLong(1);
                        int _tmp_1 = _cursor.getInt(2);
                        boolean _tmpIsPriorityData = _tmp_1 != 0;
                        int _tmpEventSizeBytes = _cursor.getInt(3);
                        EventMetadata _item = new EventMetadata(_tmpId, _tmpTimestamp, _tmpIsPriorityData, _tmpEventSizeBytes);
                        _result.add(_item);
                    }
                    ArrayList<EventMetadata> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object fetchEventRecordByIds(List<Long> recordIds, Continuation<? super List<EventRecord>> $completion) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM events WHERE id IN (");
        int _inputSize = recordIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : recordIds) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<EventRecord>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<EventRecord> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)EventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfEvent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"event");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfIsPriorityData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPriorityData");
                    int _cursorIndexOfEventSizeBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventSizeBytes");
                    ArrayList<EventRecord> _result = new ArrayList<EventRecord>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpEvent = _cursor.getString(_cursorIndexOfEvent);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsPriorityData);
                        boolean _tmpIsPriorityData = _tmp != 0;
                        int _tmpEventSizeBytes = _cursor.getInt(_cursorIndexOfEventSizeBytes);
                        EventRecord _item_1 = new EventRecord(_tmpId, _tmpEvent, _tmpTimestamp, _tmpIsPriorityData, _tmpEventSizeBytes);
                        _result.add(_item_1);
                    }
                    ArrayList<EventRecord> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Object deleteById(final List<Long> recordIds, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM events WHERE id IN (");
                int _inputSize = recordIds.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = EventDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                Unit unit = recordIds.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                EventDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    EventDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    EventDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

