/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.lifecycle;

import android.app.Application;
import android.os.Build;
import com.dynatrace.agent.lifecycle.AppStartupManager;
import com.dynatrace.agent.lifecycle.VisibilityManager;
import com.dynatrace.agent.lifecycle.callback.ActivityLifecycleListener;
import com.dynatrace.agent.lifecycle.callback.ActivityLifecycleListenerLegacy;
import com.dynatrace.agent.lifecycle.model.AppStartupPhase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/agent/lifecycle/OneAgentLifecycleManager;", "", "appStartupManager", "Lcom/dynatrace/agent/lifecycle/AppStartupManager;", "visibilityManager", "Lcom/dynatrace/agent/lifecycle/VisibilityManager;", "application", "Landroid/app/Application;", "<init>", "(Lcom/dynatrace/agent/lifecycle/AppStartupManager;Lcom/dynatrace/agent/lifecycle/VisibilityManager;Landroid/app/Application;)V", "isAppStarted", "", "activityLifecycleListener", "Landroid/app/Application$ActivityLifecycleCallbacks;", "onAppStart", "", "onAgentShutdown", "com.dynatrace.agent_release"})
public final class OneAgentLifecycleManager {
    @NotNull
    private final AppStartupManager appStartupManager;
    @NotNull
    private final Application application;
    private boolean isAppStarted;
    @NotNull
    private final Application.ActivityLifecycleCallbacks activityLifecycleListener;

    public OneAgentLifecycleManager(@NotNull AppStartupManager appStartupManager, @NotNull VisibilityManager visibilityManager, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)appStartupManager, (String)"appStartupManager");
        Intrinsics.checkNotNullParameter((Object)visibilityManager, (String)"visibilityManager");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.appStartupManager = appStartupManager;
        this.application = application;
        this.activityLifecycleListener = Build.VERSION.SDK_INT >= 29 ? (Application.ActivityLifecycleCallbacks)new ActivityLifecycleListener(this.appStartupManager, visibilityManager) : (Application.ActivityLifecycleCallbacks)new ActivityLifecycleListenerLegacy(this.appStartupManager, visibilityManager);
    }

    public final void onAppStart() {
        if (!this.isAppStarted) {
            this.isAppStarted = true;
            this.appStartupManager.onStartupPhase(AppStartupPhase.APPLICATION_CREATE);
            this.application.registerActivityLifecycleCallbacks(this.activityLifecycleListener);
        }
    }

    public final void onAgentShutdown() {
        this.isAppStarted = false;
        this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleListener);
    }
}

