/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.network.response;

import com.dynatrace.agent.communication.api.AgentState;
import com.dynatrace.agent.communication.network.response.JsonExtensionKt;
import com.dynatrace.agent.communication.network.response.ParsedResponse;
import com.dynatrace.agent.communication.network.response.ServerConfigurationManagerV4Kt;
import com.dynatrace.agent.storage.preference.ServerConfigurationV4;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/agent/communication/network/response/ServerConfigurationManagerV4;", "", "<init>", "()V", "parseResponseOrNull", "Lcom/dynatrace/agent/communication/network/response/ParsedResponse;", "currentRevision", "", "appId", "", "json", "parseResponseOrNull$com_dynatrace_agent_release", "calculateMaxBeaconSizeKib", "", "tenantConfig", "Lorg/json/JSONObject;", "appConfig", "calculateMaxEventSizeKib", "hasAppOrTenantSettings", "key", "Companion", "com.dynatrace.agent_release"})
public final class ServerConfigurationManagerV4 {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_STATUS = "status";
    @NotNull
    private static final String KEY_REVISION = "revision";
    @NotNull
    private static final String KEY_ENVIRONMENT_CONFIG = "environmentConfig";
    @NotNull
    private static final String KEY_APP_CONFIG = "appConfig";
    @NotNull
    private static final String KEY_DYNAMIC_CONFIG = "dynamicConfig";
    @NotNull
    private static final String KEY_MAX_BEACON_SIZE_KIB = "maxBeaconSizeKib";
    @NotNull
    private static final String KEY_MAX_EVENT_SIZE_KIB = "maxEventSizeKib";
    @NotNull
    private static final String KEY_DYNAMIC_CONFIG_STATE = "state";
    @NotNull
    private static final String KEY_APP_CONFIG_APP_ID = "applicationId";
    @NotNull
    private static final String KEY_APP_CONFIG_CAPTURE = "capture";

    @Nullable
    public final ParsedResponse parseResponseOrNull$com_dynatrace_agent_release(long currentRevision, @NotNull String appId, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            AgentState agentState;
            JSONObject dynamicConfig;
            Object object = new JSONTokener(json).nextValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.json.JSONObject");
            JSONObject rootJson = (JSONObject)object;
            String status = JsonExtensionKt.getStringOrNull(rootJson, KEY_STATUS);
            if (!ArraysKt.contains((Object[])ServerConfigurationManagerV4Kt.access$getSTATUS_VALUES$p(), (Object)status)) {
                Utility.devLog("dtxCommunication", "config parsing error: unknown status value");
                return null;
            }
            JSONObject jSONObject = dynamicConfig = rootJson.optJSONObject(KEY_DYNAMIC_CONFIG);
            AgentState agentState2 = agentState = jSONObject != null ? ServerConfigurationManagerV4Kt.access$getAgentStateOrNull(jSONObject, KEY_DYNAMIC_CONFIG_STATE) : null;
            if (agentState == null) {
                Utility.devLog("dtxCommunication", "config parsing error: unknown agent state");
                return null;
            }
            Long revision = JsonExtensionKt.getLongOrNull(rootJson, KEY_REVISION);
            if (revision == null || revision <= currentRevision) {
                return new ParsedResponse(agentState, null);
            }
            JSONObject tenantConfig = rootJson.optJSONObject(KEY_ENVIRONMENT_CONFIG);
            JSONObject appConfig = rootJson.optJSONObject(KEY_APP_CONFIG);
            if (tenantConfig == null || appConfig == null) {
                Utility.devLog("dtxCommunication", "config parsing error: invalid config update");
                return null;
            }
            if (!Intrinsics.areEqual((Object)appId, (Object)JsonExtensionKt.getStringOrNull(appConfig, KEY_APP_CONFIG_APP_ID))) {
                Utility.devLog("dtxCommunication", "config parsing error: appId mismatch");
                return null;
            }
            ServerConfigurationV4 newConfiguration = new ServerConfigurationV4(revision, this.calculateMaxBeaconSizeKib(tenantConfig, appConfig), this.calculateMaxEventSizeKib(tenantConfig, appConfig), appConfig.optBoolean(KEY_APP_CONFIG_CAPTURE, true));
            return new ParsedResponse(agentState, newConfiguration);
        }
        catch (Exception e) {
            Utility.devLog("dtxCommunication", "config parsing error: invalid JSON", e);
            return null;
        }
    }

    private final int calculateMaxBeaconSizeKib(JSONObject tenantConfig, JSONObject appConfig) {
        JSONObject jSONObject = this.hasAppOrTenantSettings(KEY_MAX_BEACON_SIZE_KIB, tenantConfig, appConfig);
        return jSONObject != null ? ServerConfigurationManagerV4Kt.access$getIntOrClosest(jSONObject, KEY_MAX_BEACON_SIZE_KIB, 256, 10240, 1024) : 1024;
    }

    private final int calculateMaxEventSizeKib(JSONObject tenantConfig, JSONObject appConfig) {
        JSONObject jSONObject = this.hasAppOrTenantSettings(KEY_MAX_EVENT_SIZE_KIB, tenantConfig, appConfig);
        return jSONObject != null ? ServerConfigurationManagerV4Kt.access$getIntOrClosest(jSONObject, KEY_MAX_EVENT_SIZE_KIB, 128, 1024, 256) : 256;
    }

    private final JSONObject hasAppOrTenantSettings(String key, JSONObject tenantConfig, JSONObject appConfig) {
        return appConfig.has(key) ? appConfig : (tenantConfig.has(key) ? tenantConfig : null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/agent/communication/network/response/ServerConfigurationManagerV4$Companion;", "", "<init>", "()V", "KEY_STATUS", "", "KEY_REVISION", "KEY_ENVIRONMENT_CONFIG", "KEY_APP_CONFIG", "KEY_DYNAMIC_CONFIG", "KEY_MAX_BEACON_SIZE_KIB", "KEY_MAX_EVENT_SIZE_KIB", "KEY_DYNAMIC_CONFIG_STATE", "KEY_APP_CONFIG_APP_ID", "KEY_APP_CONFIG_CAPTURE", "com.dynatrace.agent_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

