/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.network.request;

import com.dynatrace.agent.communication.network.model.RetryInfo;
import com.dynatrace.agent.communication.network.request.Compression;
import com.dynatrace.agent.storage.db.EndPointInfo;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a4\u0010\f\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u0006*\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u001d\u0010\u0017\u001a\u00020\u0006*\u00020\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0006H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0001*\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"BEACON_TYPE", "", "CONTENT_TYPE", "PROTOCOL_VERSION", "TECHNOLOGY_TYPE", "addBaseQueryParameters", "Lokhttp3/HttpUrl$Builder;", "endPointInfo", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "version", "revision", "", "addBodyQueryParameters", "body", "", "compression", "Lcom/dynatrace/agent/communication/network/request/Compression;", "priority", "timeStampGenerator", "Lkotlin/Function0;", "addRetryQueryParameters", "retryInfo", "Lcom/dynatrace/agent/communication/network/model/RetryInfo;", "addServerIdParameter", "serverId", "", "(Lokhttp3/HttpUrl$Builder;Ljava/lang/Integer;)Lokhttp3/HttpUrl$Builder;", "buildWithQueryChecksum", "Lokhttp3/HttpUrl;", "generateCrcChecksum", "com.dynatrace.agent_release"})
public final class HttpUrlExtensionsKt {
    @NotNull
    private static final String BEACON_TYPE = "mb";
    @NotNull
    private static final String PROTOCOL_VERSION = "4";
    @NotNull
    private static final String TECHNOLOGY_TYPE = "android";
    @NotNull
    private static final String CONTENT_TYPE = "event";

    @NotNull
    public static final HttpUrl.Builder addBaseQueryParameters(@NotNull HttpUrl.Builder $this$addBaseQueryParameters, @NotNull EndPointInfo endPointInfo, @NotNull String version, long revision) {
        Intrinsics.checkNotNullParameter((Object)$this$addBaseQueryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)endPointInfo, (String)"endPointInfo");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        $this$addBaseQueryParameters.addQueryParameter("ty", BEACON_TYPE);
        $this$addBaseQueryParameters.addQueryParameter("pv", PROTOCOL_VERSION);
        $this$addBaseQueryParameters.addQueryParameter("tt", TECHNOLOGY_TYPE);
        $this$addBaseQueryParameters.addQueryParameter("av", version);
        $this$addBaseQueryParameters.addQueryParameter("ai", endPointInfo.getApplicationId());
        $this$addBaseQueryParameters.addQueryParameter("cr", String.valueOf(revision));
        return $this$addBaseQueryParameters;
    }

    @NotNull
    public static final HttpUrl.Builder addRetryQueryParameters(@NotNull HttpUrl.Builder $this$addRetryQueryParameters, @Nullable RetryInfo retryInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$addRetryQueryParameters, (String)"<this>");
        if (retryInfo == null) {
            return $this$addRetryQueryParameters;
        }
        $this$addRetryQueryParameters.addQueryParameter("rc", String.valueOf(retryInfo.getCount()));
        if (retryInfo.getReason() != null) {
            $this$addRetryQueryParameters.addQueryParameter("rr", retryInfo.getReason());
        }
        return $this$addRetryQueryParameters;
    }

    public static /* synthetic */ HttpUrl.Builder addRetryQueryParameters$default(HttpUrl.Builder builder, RetryInfo retryInfo, int n, Object object) {
        if ((n & 1) != 0) {
            retryInfo = null;
        }
        return HttpUrlExtensionsKt.addRetryQueryParameters(builder, retryInfo);
    }

    @NotNull
    public static final HttpUrl.Builder addBodyQueryParameters(@NotNull HttpUrl.Builder $this$addBodyQueryParameters, @NotNull byte[] body, @NotNull Compression compression, @Nullable String priority, @NotNull Function0<Long> timeStampGenerator) {
        Intrinsics.checkNotNullParameter((Object)$this$addBodyQueryParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter(timeStampGenerator, (String)"timeStampGenerator");
        $this$addBodyQueryParameters.addQueryParameter("cy", CONTENT_TYPE);
        if (priority != null) {
            $this$addBodyQueryParameters.addQueryParameter("pr", priority);
        }
        $this$addBodyQueryParameters.addQueryParameter("bc", HttpUrlExtensionsKt.generateCrcChecksum(body));
        if (compression != Compression.UNCOMPRESSED) {
            $this$addBodyQueryParameters.addQueryParameter("co", compression.getDescription());
        }
        $this$addBodyQueryParameters.addQueryParameter("st", String.valueOf(((Number)timeStampGenerator.invoke()).longValue()));
        return $this$addBodyQueryParameters;
    }

    @NotNull
    public static final HttpUrl.Builder addServerIdParameter(@NotNull HttpUrl.Builder $this$addServerIdParameter, @Nullable Integer serverId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addServerIdParameter, (String)"<this>");
            Integer n = serverId;
            if (n == null) break block0;
            int id = ((Number)n).intValue();
            boolean bl = false;
            $this$addServerIdParameter.addQueryParameter("si", String.valueOf(id));
        }
        return $this$addServerIdParameter;
    }

    public static /* synthetic */ HttpUrl.Builder addServerIdParameter$default(HttpUrl.Builder builder, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return HttpUrlExtensionsKt.addServerIdParameter(builder, n);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final HttpUrl buildWithQueryChecksum(@NotNull HttpUrl.Builder $this$buildWithQueryChecksum) {
        Intrinsics.checkNotNullParameter((Object)$this$buildWithQueryChecksum, (String)"<this>");
        httpUrl = $this$buildWithQueryChecksum.build();
        v0 = httpUrl.encodedQuery();
        if (v0 == null) ** GOTO lbl-1000
        v1 = StringsKt.encodeToByteArray((String)v0);
        v0 = v1;
        if (v1 != null) {
            v2 = HttpUrlExtensionsKt.generateCrcChecksum((byte[])v0);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        crc = v2;
        return httpUrl.newBuilder().addQueryParameter("qc", crc).addQueryParameter("end", "1").build();
    }

    @NotNull
    public static final String generateCrcChecksum(@NotNull byte[] $this$generateCrcChecksum) {
        Intrinsics.checkNotNullParameter((Object)$this$generateCrcChecksum, (String)"<this>");
        CRC32 crcGen = new CRC32();
        crcGen.update($this$generateCrcChecksum);
        return String.valueOf(crcGen.getValue());
    }
}

