/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication.network.request;

import com.dynatrace.agent.communication.network.CompressionToolkitKt;
import com.dynatrace.agent.communication.network.datasource.DataRequest;
import com.dynatrace.agent.communication.network.request.Compression;
import com.dynatrace.agent.communication.network.request.HttpUrlExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/agent/communication/network/request/DataRequestFactory;", "", "version", "", "timestampProvider", "Lkotlin/Function0;", "", "useCompression", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Z)V", "createRequest", "Lokhttp3/Request;", "dataRequest", "Lcom/dynatrace/agent/communication/network/datasource/DataRequest;", "com.dynatrace.agent_release"})
public final class DataRequestFactory {
    @NotNull
    private final String version;
    @NotNull
    private final Function0<Long> timestampProvider;
    private final boolean useCompression;

    public DataRequestFactory(@NotNull String version, @NotNull Function0<Long> timestampProvider, boolean useCompression) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(timestampProvider, (String)"timestampProvider");
        this.version = version;
        this.timestampProvider = timestampProvider;
        this.useCompression = useCompression;
    }

    public /* synthetic */ DataRequestFactory(String string, Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, (Function0<Long>)function0, bl);
    }

    @NotNull
    public final Request createRequest(@NotNull DataRequest dataRequest) {
        Intrinsics.checkNotNullParameter((Object)dataRequest, (String)"dataRequest");
        byte[] postBodyBytes = null;
        MediaType mediaType = null;
        Compression compressionMethod = null;
        if (this.useCompression) {
            postBodyBytes = CompressionToolkitKt.gzipDeflate(dataRequest.getBody());
            mediaType = MediaType.Companion.get("application/octet-stream");
            compressionMethod = Compression.GZIP;
        } else {
            postBodyBytes = StringsKt.encodeToByteArray((String)dataRequest.getBody());
            mediaType = MediaType.Companion.get("application/json;charset=UTF-8");
            compressionMethod = Compression.UNCOMPRESSED;
        }
        Headers.Builder headers = new Headers.Builder().add("accept-encoding", "gzip");
        RequestBody requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])postBodyBytes, (MediaType)mediaType, (int)0, (int)0, (int)6, null);
        HttpUrl.Builder builder = HttpUrlExtensionsKt.addBaseQueryParameters(HttpUrl.Companion.get(dataRequest.getEndPointInfo().getUrl()).newBuilder(), dataRequest.getEndPointInfo(), this.version, dataRequest.getServerData().getConfig().getRevision());
        String string = dataRequest.isPriority() ? "high" : null;
        Function0<Long> function0 = this.timestampProvider;
        HttpUrl url = HttpUrlExtensionsKt.buildWithQueryChecksum(HttpUrlExtensionsKt.addServerIdParameter(HttpUrlExtensionsKt.addRetryQueryParameters(HttpUrlExtensionsKt.addBodyQueryParameters(builder, postBodyBytes, compressionMethod, string, function0), dataRequest.getRetryInfo()), dataRequest.getServerId()));
        return new Request.Builder().post(requestBody).headers(headers.build()).url(url).build();
    }
}

