/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.internal.ClassLoadingCollector;
import com.dylibso.chicory.compiler.internal.Compiler;
import com.dylibso.chicory.compiler.internal.CompilerResult;
import com.dylibso.chicory.runtime.CompiledModule;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.wasm.WasmModule;
import java.util.function.Function;

public final class MachineFactory
implements Function<Instance, Machine>,
CompiledModule {
    private final WasmModule module;
    private final Function<Instance, Machine> factory;

    public MachineFactory(WasmModule module) {
        this.module = module;
        Compiler compiler = Compiler.builder(module).withClassCollectorFactory(ClassLoadingCollector::new).build();
        CompilerResult result = compiler.compile();
        ClassLoadingCollector collector = (ClassLoadingCollector)result.collector();
        this.factory = collector.machineFactory();
    }

    public MachineFactory(WasmModule module, Function<Instance, Machine> factory) {
        this.module = module;
        this.factory = factory;
    }

    @Override
    public Machine apply(Instance instance) {
        if (instance.module() != this.module) {
            throw new IllegalArgumentException("Instance module does not match factory module");
        }
        return this.factory.apply(instance);
    }

    public WasmModule wasmModule() {
        return this.module;
    }

    public Function<Instance, Machine> machineFactory() {
        return this.factory;
    }
}

