/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler;

import com.dylibso.chicory.compiler.Cache;
import com.dylibso.chicory.compiler.InterpreterFallback;
import com.dylibso.chicory.compiler.internal.ClassLoadingCollector;
import com.dylibso.chicory.compiler.internal.Compiler;
import com.dylibso.chicory.compiler.internal.CompilerResult;
import com.dylibso.chicory.compiler.internal.MachineFactory;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.WasmModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public final class MachineFactoryCompiler {
    private MachineFactoryCompiler() {
    }

    public static Machine compile(Instance instance) {
        return MachineFactoryCompiler.compile(instance.module()).apply(instance);
    }

    public static Function<Instance, Machine> compile(WasmModule module) {
        return new MachineFactory(module);
    }

    public static Builder builder(WasmModule module) {
        return new Builder(module);
    }

    private static byte[] storeClassLoadingCollector(ClassLoadingCollector collector) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (JarOutputStream jos = new JarOutputStream(baos);){
                Properties properties = new Properties();
                properties.put("mainClass", collector.mainClassName());
                ByteArrayOutputStream propsBaos = new ByteArrayOutputStream();
                properties.store(propsBaos, "");
                JarEntry propsEntry = new JarEntry("wasm-module.properties");
                jos.putNextEntry(propsEntry);
                jos.write(propsBaos.toByteArray());
                jos.closeEntry();
                for (Map.Entry<String, byte[]> entry : collector.classBytes().entrySet()) {
                    String className = entry.getKey().replace('.', '/') + ".class";
                    JarEntry classEntry = new JarEntry(className);
                    jos.putNextEntry(classEntry);
                    jos.write(entry.getValue());
                    jos.closeEntry();
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ClassLoadingCollector loadClassLoadingCollector(byte[] jarData) throws IOException {
        ClassLoadingCollector collector = new ClassLoadingCollector();
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(jarData));){
            JarEntry entry;
            Properties properties = new Properties();
            String mainClass = null;
            HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.getName().equals("wasm-module.properties")) {
                    properties.load(jis);
                    mainClass = properties.getProperty("mainClass");
                } else if (entry.getName().endsWith(".class")) {
                    int bytesRead;
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = jis.read(buffer)) != -1) {
                        baos.write(buffer, 0, bytesRead);
                    }
                    classes.put(className, baos.toByteArray());
                }
                jis.closeEntry();
            }
            for (Map.Entry classEntry : classes.entrySet()) {
                if (((String)classEntry.getKey()).equals(mainClass)) {
                    collector.putMainClass(mainClass, (byte[])classEntry.getValue());
                    continue;
                }
                collector.put((String)classEntry.getKey(), (byte[])classEntry.getValue());
            }
        }
        return collector;
    }

    public static final class Builder {
        private final WasmModule module;
        private final Compiler.Builder compilerBuilder;
        private Cache cache;

        private Builder(WasmModule module) {
            this.module = module;
            this.compilerBuilder = Compiler.builder(module);
        }

        public Builder withClassName(String className) {
            this.compilerBuilder.withClassName(className);
            return this;
        }

        public Builder withMaxFunctionsPerClass(int maxFunctionsPerClass) {
            this.compilerBuilder.withMaxFunctionsPerClass(maxFunctionsPerClass);
            return this;
        }

        public Builder withInterpreterFallback(InterpreterFallback interpreterFallback) {
            this.compilerBuilder.withInterpreterFallback(interpreterFallback);
            return this;
        }

        public Builder withInterpretedFunctions(Set<Integer> interpretedFunctions) {
            this.compilerBuilder.withInterpretedFunctions(interpretedFunctions);
            return this;
        }

        public Builder withCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Function<Instance, Machine> compile() {
            try {
                byte[] cachedData;
                boolean useCache;
                boolean bl = useCache = this.cache != null && this.module.digest() != null;
                if (useCache && (cachedData = this.cache.get(this.module.digest())) != null) {
                    ClassLoadingCollector collector = MachineFactoryCompiler.loadClassLoadingCollector(cachedData);
                    return new MachineFactory(this.module, collector.machineFactory());
                }
                CompilerResult result = this.compilerBuilder.withClassCollectorFactory(ClassLoadingCollector::new).build().compile();
                ClassLoadingCollector collector = (ClassLoadingCollector)result.collector();
                if (useCache) {
                    this.cache.putIfAbsent(this.module.digest(), MachineFactoryCompiler.storeClassLoadingCollector(collector));
                }
                return new MachineFactory(this.module, collector.machineFactory());
            }
            catch (IOException e) {
                throw new ChicoryException((Throwable)e);
            }
        }
    }
}

