/*
 * Decompiled with CFR 0.152.
 */
package com.duolingo.open.rtlviewpager;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.duolingo.open.rtlviewpager.DelegatingPagerAdapter;
import java.util.HashMap;

public class RtlViewPager
extends ViewPager {
    private final HashMap<ViewPager.OnPageChangeListener, ReversingOnPageChangeListener> mPageChangeListeners = new HashMap();
    private int mLayoutDirection = 0;

    public RtlViewPager(Context context) {
        super(context);
    }

    public RtlViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        int viewCompatLayoutDirection;
        super.onRtlPropertiesChanged(layoutDirection);
        int n = viewCompatLayoutDirection = layoutDirection == 1 ? 1 : 0;
        if (viewCompatLayoutDirection != this.mLayoutDirection) {
            PagerAdapter adapter = super.getAdapter();
            int position = 0;
            if (adapter != null) {
                position = this.getCurrentItem();
            }
            this.mLayoutDirection = viewCompatLayoutDirection;
            if (adapter != null) {
                adapter.notifyDataSetChanged();
                this.setCurrentItem(position);
            }
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        if (adapter != null) {
            adapter = new ReversingAdapter(adapter);
        }
        super.setAdapter(adapter);
        this.setCurrentItem(0);
    }

    public PagerAdapter getAdapter() {
        ReversingAdapter adapter = (ReversingAdapter)super.getAdapter();
        return adapter == null ? null : adapter.getDelegate();
    }

    private boolean isRtl() {
        return this.mLayoutDirection == 1;
    }

    public int getCurrentItem() {
        int item = super.getCurrentItem();
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            item = adapter.getCount() - item - 1;
        }
        return item;
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            position = adapter.getCount() - position - 1;
        }
        super.setCurrentItem(position, smoothScroll);
    }

    public void setCurrentItem(int position) {
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            position = adapter.getCount() - position - 1;
        }
        super.setCurrentItem(position);
    }

    @Deprecated
    public void setOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        super.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ReversingOnPageChangeListener(listener));
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mLayoutDirection);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        this.mLayoutDirection = ss.mLayoutDirection;
        super.onRestoreInstanceState(ss.mViewPagerSavedState);
    }

    public void addOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        ReversingOnPageChangeListener reversingListener = new ReversingOnPageChangeListener(listener);
        this.mPageChangeListeners.put(listener, reversingListener);
        super.addOnPageChangeListener((ViewPager.OnPageChangeListener)reversingListener);
    }

    public void removeOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        ReversingOnPageChangeListener reverseListener = this.mPageChangeListeners.remove(listener);
        if (reverseListener != null) {
            super.removeOnPageChangeListener((ViewPager.OnPageChangeListener)reverseListener);
        }
    }

    public void clearOnPageChangeListeners() {
        super.clearOnPageChangeListeners();
        this.mPageChangeListeners.clear();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            int height = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int h = child.getMeasuredHeight();
                if (h <= height) continue;
                height = h;
            }
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private class ReversingAdapter
    extends DelegatingPagerAdapter {
        ReversingAdapter(PagerAdapter adapter) {
            super(adapter);
        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.destroyItem(container, position, object);
        }

        @Override
        @Deprecated
        public void destroyItem(@NonNull View container, int position, @NonNull Object object) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.destroyItem(container, position, object);
        }

        @Override
        public int getItemPosition(@NonNull Object object) {
            int position = super.getItemPosition(object);
            if (RtlViewPager.this.isRtl()) {
                position = position == -1 || position == -2 ? -2 : this.getCount() - position - 1;
            }
            return position;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.getPageTitle(position);
        }

        @Override
        public float getPageWidth(int position) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.getPageWidth(position);
        }

        @Override
        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.instantiateItem(container, position);
        }

        @Override
        @Deprecated
        @NonNull
        public Object instantiateItem(@NonNull View container, int position) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.instantiateItem(container, position);
        }

        @Override
        public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.setPrimaryItem(container, position, object);
        }

        @Override
        @Deprecated
        public void setPrimaryItem(@NonNull View container, int position, @NonNull Object object) {
            if (RtlViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.setPrimaryItem(container, position, object);
        }
    }

    private class ReversingOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final ViewPager.OnPageChangeListener mListener;

        ReversingOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
            this.mListener = listener;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int width = RtlViewPager.this.getWidth();
            PagerAdapter adapter = RtlViewPager.super.getAdapter();
            if (RtlViewPager.this.isRtl() && adapter != null) {
                int remainingWidth;
                int count = adapter.getCount();
                for (remainingWidth = (int)((float)width * (1.0f - adapter.getPageWidth(position))) + positionOffsetPixels; position < count && remainingWidth > 0; remainingWidth -= (int)((float)width * adapter.getPageWidth(++position))) {
                }
                position = count - position - 1;
                positionOffsetPixels = -remainingWidth;
                positionOffset = (float)positionOffsetPixels / ((float)width * adapter.getPageWidth(position));
            }
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            PagerAdapter adapter = RtlViewPager.super.getAdapter();
            if (RtlViewPager.this.isRtl() && adapter != null) {
                position = adapter.getCount() - position - 1;
            }
            this.mListener.onPageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public static class SavedState
    implements Parcelable {
        private final Parcelable mViewPagerSavedState;
        private final int mLayoutDirection;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return this.createFromParcel(source, null);
            }

            public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                return new SavedState(source, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable viewPagerSavedState, int layoutDirection) {
            this.mViewPagerSavedState = viewPagerSavedState;
            this.mLayoutDirection = layoutDirection;
        }

        private SavedState(Parcel in, ClassLoader loader) {
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            this.mViewPagerSavedState = in.readParcelable(loader);
            this.mLayoutDirection = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeParcelable(this.mViewPagerSavedState, flags);
            out.writeInt(this.mLayoutDirection);
        }
    }
}

