/*
 * Decompiled with CFR 0.152.
 */
package com.duolingo.open.rtlviewpager;

import android.database.DataSetObserver;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;

public class DelegatingPagerAdapter
extends PagerAdapter {
    private final PagerAdapter mDelegate;

    DelegatingPagerAdapter(@NonNull PagerAdapter delegate) {
        this.mDelegate = delegate;
        delegate.registerDataSetObserver((DataSetObserver)new MyDataSetObserver(this));
    }

    PagerAdapter getDelegate() {
        return this.mDelegate;
    }

    public int getCount() {
        return this.mDelegate.getCount();
    }

    public void startUpdate(@NonNull ViewGroup container) {
        this.mDelegate.startUpdate(container);
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        return this.mDelegate.instantiateItem(container, position);
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        this.mDelegate.destroyItem(container, position, object);
    }

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        this.mDelegate.setPrimaryItem(container, position, object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        this.mDelegate.finishUpdate(container);
    }

    @Deprecated
    public void startUpdate(@NonNull View container) {
        this.mDelegate.startUpdate(container);
    }

    @Deprecated
    @NonNull
    public Object instantiateItem(@NonNull View container, int position) {
        return this.mDelegate.instantiateItem(container, position);
    }

    @Deprecated
    public void destroyItem(@NonNull View container, int position, @NonNull Object object) {
        this.mDelegate.destroyItem(container, position, object);
    }

    @Deprecated
    public void setPrimaryItem(@NonNull View container, int position, @NonNull Object object) {
        this.mDelegate.setPrimaryItem(container, position, object);
    }

    @Deprecated
    public void finishUpdate(@NonNull View container) {
        this.mDelegate.finishUpdate(container);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return this.mDelegate.isViewFromObject(view, object);
    }

    public Parcelable saveState() {
        return this.mDelegate.saveState();
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        this.mDelegate.restoreState(state, loader);
    }

    public int getItemPosition(@NonNull Object object) {
        return this.mDelegate.getItemPosition(object);
    }

    public void notifyDataSetChanged() {
        this.mDelegate.notifyDataSetChanged();
    }

    public void registerDataSetObserver(@NonNull DataSetObserver observer) {
        this.mDelegate.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(@NonNull DataSetObserver observer) {
        this.mDelegate.unregisterDataSetObserver(observer);
    }

    public CharSequence getPageTitle(int position) {
        return this.mDelegate.getPageTitle(position);
    }

    public float getPageWidth(int position) {
        return this.mDelegate.getPageWidth(position);
    }

    private void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    private static class MyDataSetObserver
    extends DataSetObserver {
        final DelegatingPagerAdapter mParent;

        private MyDataSetObserver(DelegatingPagerAdapter mParent) {
            this.mParent = mParent;
        }

        public void onChanged() {
            if (this.mParent != null) {
                this.mParent.superNotifyDataSetChanged();
            }
        }

        public void onInvalidated() {
            this.onChanged();
        }
    }
}

