/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.forest.springboot;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.SpringInterceptorFactory;
import com.dtflys.forest.scanner.ClassPathClientScanner;
import com.dtflys.forest.schema.ForestConfigurationBeanDefinitionParser;
import com.dtflys.forest.utils.StringUtils;
import com.thebeastshop.forest.springboot.annotation.ForestScannerRegister;
import com.thebeastshop.forest.springboot.properties.ForestConfigurationProperties;
import com.thebeastshop.forest.springboot.properties.ForestSSLKeyStoreProperties;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ForestBeanRegister
implements ResourceLoaderAware,
BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private ResourceLoader resourceLoader;
    private ForestConfigurationProperties forestConfigurationProperties;

    public ForestBeanRegister(ConfigurableApplicationContext applicationContext, ForestConfigurationProperties forestConfigurationProperties) {
        this.applicationContext = applicationContext;
        this.forestConfigurationProperties = forestConfigurationProperties;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ForestConfiguration registerForestConfiguration(ForestConfigurationProperties forestConfigurationProperties) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ForestConfiguration.class);
        String id = forestConfigurationProperties.getBeanId();
        if (StringUtils.isBlank((String)id)) {
            id = "forestConfiguration";
        }
        beanDefinitionBuilder.addPropertyValue("maxConnections", (Object)forestConfigurationProperties.getMaxConnections()).addPropertyValue("maxRouteConnections", (Object)forestConfigurationProperties.getMaxRouteConnections()).addPropertyValue("timeout", (Object)forestConfigurationProperties.getTimeout()).addPropertyValue("connectTimeout", (Object)forestConfigurationProperties.getConnectTimeout()).addPropertyValue("charset", (Object)forestConfigurationProperties.getCharset()).addPropertyValue("retryer", (Object)forestConfigurationProperties.getRetryer()).addPropertyValue("retryCount", (Object)forestConfigurationProperties.getRetryCount()).addPropertyValue("maxRetryInterval", (Object)forestConfigurationProperties.getMaxRetryInterval()).addPropertyValue("logEnabled", (Object)forestConfigurationProperties.isLogEnabled()).addPropertyValue("backendName", (Object)forestConfigurationProperties.getBackend()).addPropertyValue("interceptors", forestConfigurationProperties.getInterceptors()).addPropertyValue("sslProtocol", (Object)forestConfigurationProperties.getSslProtocol()).addPropertyValue("variables", forestConfigurationProperties.getVariables()).setLazyInit(false).setFactoryMethod("configuration");
        BeanDefinition interceptorFactoryBeanDefinition = this.registerInterceptorFactoryBean();
        beanDefinitionBuilder.addPropertyValue("interceptorFactory", (Object)interceptorFactoryBeanDefinition);
        List<ForestSSLKeyStoreProperties> sslKeyStorePropertiesList = forestConfigurationProperties.getSslKeyStores();
        ManagedMap sslKeystoreMap = new ManagedMap();
        for (ForestSSLKeyStoreProperties keyStoreProperties : sslKeyStorePropertiesList) {
            this.registerSSLKeyStoreBean((ManagedMap<String, BeanDefinition>)sslKeystoreMap, keyStoreProperties);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeystoreMap);
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        ForestConfiguration configuration = (ForestConfiguration)this.applicationContext.getBean(id, ForestConfiguration.class);
        return configuration;
    }

    public BeanDefinition registerInterceptorFactoryBean() {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpringInterceptorFactory.class);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition("forestInterceptorFactory", (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    public BeanDefinition registerSSLKeyStoreBean(ManagedMap<String, BeanDefinition> map, ForestSSLKeyStoreProperties sslKeyStoreProperties) {
        String id = sslKeyStoreProperties.getId();
        if (StringUtils.isBlank((String)id)) {
            throw new ForestRuntimeException("[Forest] Property 'id' of SSL keystore can not be empty or blank");
        }
        if (map.containsKey((Object)id)) {
            throw new ForestRuntimeException("[Forest] Duplicate SSL keystore id '" + id + "'");
        }
        BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean((String)id, (String)sslKeyStoreProperties.getType(), (String)sslKeyStoreProperties.getFile(), (String)sslKeyStoreProperties.getKeystorePass(), (String)sslKeyStoreProperties.getCertPass(), (String)sslKeyStoreProperties.getProtocols(), (String)sslKeyStoreProperties.getCipherSuites());
        map.put((Object)id, (Object)beanDefinition);
        return beanDefinition;
    }

    public ClassPathClientScanner registerScanner(ForestConfigurationProperties forestConfigurationProperties) {
        List<String> basePackages = ForestScannerRegister.basePackages;
        String configurationId = ForestScannerRegister.configurationId;
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext.getBeanFactory();
        ClassPathClientScanner scanner = new ClassPathClientScanner(configurationId, registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (basePackages == null || basePackages.size() == 0) {
            return scanner;
        }
        scanner.doScan(org.springframework.util.StringUtils.toStringArray(basePackages));
        return scanner;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.registerForestConfiguration(this.forestConfigurationProperties);
        this.registerScanner(this.forestConfigurationProperties);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

