/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android.internal;

import com.dropbox.core.IncludeGrantedScopes;
import com.dropbox.core.android.AuthActivity;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/dropbox/core/android/internal/AuthUtils;", "", "()V", "createPKCEStateNonce", "", "codeChallenge", "tokenAccessType", "scope", "mIncludeGrantedScopes", "Lcom/dropbox/core/IncludeGrantedScopes;", "createStateNonce", "securityProvider", "Lcom/dropbox/core/android/AuthActivity$SecurityProvider;", "android_release"})
public final class AuthUtils {
    @NotNull
    public static final AuthUtils INSTANCE = new AuthUtils();

    private AuthUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String createStateNonce(@NotNull AuthActivity.SecurityProvider securityProvider) {
        Intrinsics.checkNotNullParameter((Object)securityProvider, (String)"securityProvider");
        int NONCE_BYTES = 16;
        byte[] randomBytes = new byte[NONCE_BYTES];
        securityProvider.getSecureRandom().nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        sb.append("oauth2:");
        for (int i = 0; i < NONCE_BYTES; ++i) {
            String string = "%02x";
            Object[] objectArray = new Object[]{randomBytes[i] & 0xFF};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            sb.append(string2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String createPKCEStateNonce(@NotNull String codeChallenge, @NotNull String tokenAccessType, @Nullable String scope, @Nullable IncludeGrantedScopes mIncludeGrantedScopes) {
        Intrinsics.checkNotNullParameter((Object)codeChallenge, (String)"codeChallenge");
        Intrinsics.checkNotNullParameter((Object)tokenAccessType, (String)"tokenAccessType");
        Locale locale = Locale.US;
        String string = "oauth2code:%s:%s:%s";
        Object[] objectArray = new Object[]{codeChallenge, "S256", tokenAccessType};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        String state = string2;
        if (scope != null) {
            state = state + ':' + scope;
        }
        if (mIncludeGrantedScopes != null) {
            state = state + ':' + mIncludeGrantedScopes;
        }
        return state;
    }
}

