/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifInteropDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifInteropDescriptor
extends TagDescriptor<ExifInteropDirectory> {
    public ExifInteropDescriptor(@NotNull ExifInteropDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getInteropIndexDescription();
            }
            case 2: {
                return this.getInteropVersionDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getInteropVersionDescription() {
        return this.getVersionBytesDescription(2, 2);
    }

    @Nullable
    public String getInteropIndexDescription() {
        String value = ((ExifInteropDirectory)this._directory).getString(1);
        if (value == null) {
            return null;
        }
        return "R98".equalsIgnoreCase(value.trim()) ? "Recommended Exif Interoperability Rules (ExifR98)" : "Unknown (" + value + ")";
    }
}

