/*
 * Decompiled with CFR 0.152.
 */
package com.dreamlive.cn.clog;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CollectLog
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = CollectLog.class.getCanonicalName();
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static CollectLog INSTANCE = new CollectLog();
    private Context mContext;
    private Map<String, String> infos = new HashMap<String, String>();
    private DateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private String filePath = "";

    private CollectLog() {
    }

    public static CollectLog getInstance() {
        return INSTANCE;
    }

    public void init(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void init(Context context, String path) {
        this.init(context);
        this.filePath = path;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        this.collectDeviceInfo(this.mContext);
        String str = this.saveCrashInfo2File(ex);
        Log.e((String)TAG, (String)str);
        return false;
    }

    public void collectDeviceInfo(Context ctx) {
        Field[] fields;
        try {
            PackageManager pm = ctx.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(ctx.getPackageName(), 1);
            if (pi != null) {
                String versionName = pi.versionName == null ? "null" : pi.versionName;
                String versionCode = pi.versionCode + "";
                this.infos.put("versionName", versionName);
                this.infos.put("versionCode", versionCode);
            }
        }
        catch (PackageManager.NameNotFoundException pm) {
            // empty catch block
        }
        for (Field field : fields = Build.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.infos.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append("[" + key + ", " + value + "]\n");
        }
        sb.append("\n" + CollectLog.getStackTraceString(ex));
        try {
            String time = this.formatter.format(new Date());
            String fileName = "CRS_" + time + ".txt";
            File sdDir = null;
            sdDir = this.mContext.getExternalFilesDir("logs").getAbsoluteFile();
            File file = null;
            if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
                File files = new File(this.filePath);
                if (!files.exists()) {
                    files.mkdirs();
                }
                file = new File(this.filePath + File.separator + fileName);
            } else {
                file = new File(sdDir + File.separator + fileName);
            }
            if (file == null) {
                file = new File(sdDir + File.separator + fileName);
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(sb.toString().getBytes());
            fos.close();
            return fileName;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStackTraceString(Throwable tr) {
        try {
            if (tr == null) {
                return "";
            }
            for (Throwable t = tr; t != null; t = t.getCause()) {
                if (!(t instanceof UnknownHostException)) continue;
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            tr.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

