/*
 * Decompiled with CFR 0.152.
 */
package com.drand.bottomnavigation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BottomNavigationLayout
extends ViewGroup {
    private static final String TAG = "BottomNavigationLayout";
    public static final int ENV_STANDARD = 0;
    public static final int ENV_REACT_NATIVE = 1;
    private static final int MODE_DEFAULT = 0;
    public static final int MODE_FIXED = 1;
    public static final int MODE_SHIFTING = 2;
    public static final int MODE_FORCE_FIXED = 3;
    public static final int STATE_IDLE = 0;
    public static final int STATE_SELECTING = 1;
    public static final int STATE_SETTLING = 2;
    private static final int CONTENT_INDEX = 0;
    private static final int TABBAR_INDEX = 1;
    private static final int INJECTED_CONTENT_INDEX = 0;
    private static final int SHADOW_INDEX = 1;
    public static final int MIN_ITEMS = 3;
    public static final int MAX_ITEMS = 5;
    private static final int ELEVATION = 8;
    private static final int BAR_HEIGHT = 56;
    private static final int MAX_TAB_WIDTH_FIXED = 168;
    private static final int MIN_TAB_WIDTH_FIXED = 80;
    private static final int MAX_TAB_WIDTH_SHIFTING = 168;
    private static final int MIN_TAB_WIDTH_SHIFTING = 96;
    private static final int PADDING_TOP_ACTIVE_FIXED = 6;
    private static final int PADDING_TOP_INACTIVE_FIXED = 8;
    private static final int PADDING_TOP_INACTIVE_SHIFTING = 16;
    private static final int PADDING_BOTTOM = 10;
    private static final int PADDING_BOTTOM_SHIFTING_INACTIVE = 10;
    private static final int PADDING_HORIZONTAL = 12;
    private static final int PADDING_BOTTOM_ICON_SHIFTING_ACTIVE = 6;
    private int FONT_SIZE_ACTIVE_FIXED = 14;
    private int FONT_SIZE_INACTIVE_FIXED = 12;
    private int FONT_SIZE_SHIFTING = 14;
    private int SHADOW_HEIGHT = 2;
    private Context mContext;
    private int mEnv = 1;
    private int mMode = 0;
    private int mSelected = 0;
    private int mFontStyle = 0;
    private float mDensity;
    private float mElevation;
    private boolean mInLayout = false;
    private boolean mFirstLayout = true;
    private String mFontFamily = "sans-serif-condensed";
    private String mBackgroundColor;
    private String mActiveTabTintColor;
    private String mInactiveTabTintColor;
    private List<Tab> mTabs;
    private List<View> mContent;
    private ImageView mShadowView;
    private LinearLayout mTabsContainer;
    private FrameLayout mContentContainer;
    private FrameLayout mTabsOuterContainer;
    private BottomNavigationListener mListener;

    public BottomNavigationLayout(Context context) {
        this(context, null, 0);
    }

    public BottomNavigationLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mElevation = this.mDensity * 8.0f;
        this.setClipToPadding(false);
        this.setFocusableInTouchMode(true);
        ViewCompat.setElevation((View)this, (float)this.mElevation);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.mContentContainer = new FrameLayout(this.getContext());
        this.mContentContainer.setLayoutParams(lp);
        this.mContentContainer.setBackgroundColor(0);
        this.mTabsOuterContainer = new FrameLayout(this.getContext());
        this.mTabsOuterContainer.setLayoutParams(lp);
        this.mTabsOuterContainer.setBackgroundColor(0);
        this.mTabsContainer = new LinearLayout(context);
        ViewGroup.LayoutParams lpTabbar = new ViewGroup.LayoutParams(-1, -1);
        this.mTabsContainer.setLayoutParams(lpTabbar);
        this.mTabsContainer.setOrientation(0);
        this.mTabsContainer.setGravity(1);
        this.mShadowView = new ImageView(context);
        FrameLayout.LayoutParams lpShadow = new FrameLayout.LayoutParams(-1, this.dpToPixels(this.SHADOW_HEIGHT));
        lpShadow.gravity = 80;
        this.mShadowView.setLayoutParams((ViewGroup.LayoutParams)lpShadow);
        this.mShadowView.setImageDrawable(this.getShadowDrawable());
        this.mTabs = new ArrayList<Tab>();
        this.mContent = new ArrayList<View>();
        this.addView((View)this.mContentContainer, 0);
        this.addView((View)this.mTabsOuterContainer, 1);
    }

    public void createViewGroup() {
        if (this.mTabs.size() > 5) {
            throw new IllegalArgumentException("BottomNavigationLayout can have at most 5 tabs");
        }
        if (this.mContent.size() != this.mTabs.size() && this.mEnv != 1) {
            int tabs = this.mTabs.size();
            int content = this.mContent.size();
            throw new IllegalArgumentException("The number of tabs (" + tabs + ") does not match the number of content views (" + content + ")");
        }
        if (this.mBackgroundColor != null) {
            this.mTabsContainer.setBackgroundColor(Color.parseColor((String)this.mBackgroundColor));
        }
        int mostLikelyWidth = this.getResources().getDisplayMetrics().widthPixels / this.mTabs.size();
        if (this.mMode == 0) {
            this.mMode = this.mTabs.size() <= 3 ? 1 : 2;
        }
        for (int i = 0; i < this.mTabs.size(); ++i) {
            int width = 0;
            if (this.mMode != 2) {
                width = Math.max(this.dpToPixels(80), mostLikelyWidth);
                width = Math.min(this.dpToPixels(168), mostLikelyWidth);
            } else {
                width = Math.max(this.dpToPixels(96), mostLikelyWidth);
                width = Math.min(this.dpToPixels(168), mostLikelyWidth);
            }
            this.mTabs.get(i).setWidth(width);
            if (i == this.mSelected) {
                this.mTabs.get(i).select();
            } else {
                this.mTabs.get(i).deselect();
            }
            this.mTabsContainer.addView((View)this.mTabs.get(i));
        }
        this.mTabsOuterContainer.addView((View)this.mTabsContainer, 0);
        if (this.mEnv == 0) {
            this.mContentContainer.addView(this.mContent.get(this.mSelected), 0);
            this.mContentContainer.addView((View)this.mShadowView, 1);
        }
    }

    public void addItem(String title, String icon, final int index) {
        if (this.mEnv != 1) {
            throw new IllegalArgumentException("addItem(String, String, int) must be used only with ReactNative");
        }
        Tab tab = new Tab(this.mContext, title, icon, index);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BottomNavigationLayout.this.selectTab(index);
            }
        });
        this.mTabs.add(index, tab);
    }

    public void addItem(@StringRes int title, @DrawableRes int icon, final int index) {
        Tab tab = new Tab(this.mContext, title, icon, index);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BottomNavigationLayout.this.selectTab(index);
            }
        });
        this.mTabs.add(index, tab);
    }

    public void addItem(String title, @DrawableRes int icon, final int index) {
        Tab tab = new Tab(this.mContext, title, icon, index);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BottomNavigationLayout.this.selectTab(index);
            }
        });
        this.mTabs.add(index, tab);
    }

    public void addContent(View view, int index) {
        this.mContent.add(index, view);
    }

    public void addReactNativeContent(View view) {
        if (this.mContentContainer.getChildCount() > 0) {
            this.mContentContainer.removeAllViews();
        }
        this.mContentContainer.addView(view, 0);
        this.mContentContainer.addView((View)this.mShadowView, 1);
    }

    public void hideShadow() {
        if (this.mContentContainer.getChildAt(1) != null) {
            this.mContentContainer.getChildAt(1).setVisibility(8);
        }
    }

    public void showShadow() {
        if (this.mContentContainer.getChildAt(1) != null) {
            this.mContentContainer.getChildAt(1).setVisibility(0);
        }
    }

    private void selectTab(int index) {
        if (index != this.mSelected) {
            this.mTabs.get(this.mSelected).deselect();
            this.mSelected = index;
            this.mTabs.get(index).select();
            if (this.mEnv != 1) {
                this.mContentContainer.removeViewAt(0);
                this.mContentContainer.addView(this.mContent.get(index), 0);
            }
            this.dispatchOnTabSelected(index);
        } else {
            this.dispatchOnTabReSelected(index);
        }
    }

    public void setEnv(int env) {
        this.mEnv = env;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void setActiveTabTintColor(String activeTabTintColor) {
        this.mActiveTabTintColor = activeTabTintColor;
    }

    public void setInactiveTabTintColor(String inactiveTabTintColor) {
        this.mInactiveTabTintColor = inactiveTabTintColor;
    }

    public void setFontSizeActiveTabFixed(int size) {
        this.FONT_SIZE_ACTIVE_FIXED = size;
    }

    public void setFontSizeInActiveTabFixed(int size) {
        this.FONT_SIZE_INACTIVE_FIXED = size;
    }

    public void setFontSizeTabShifting(int size) {
        this.FONT_SIZE_SHIFTING = size;
    }

    public void setFontFamily(String font) {
        this.mFontFamily = font;
        if (this.mTabs.size() > 0) {
            for (int i = 0; i < this.mTabs.size(); ++i) {
                this.mTabs.get(i).getTitleView().setTypeface(Typeface.create((String)font, (int)this.mFontStyle));
            }
        }
    }

    public void setFontStyle(String style) {
        switch (style) {
            case "bold": {
                this.mFontStyle = 1;
                break;
            }
            case "italic": {
                this.mFontStyle = 2;
                break;
            }
            case "bold_italic": {
                this.mFontStyle = 3;
                break;
            }
            default: {
                this.mFontStyle = 0;
            }
        }
        if (this.mTabs.size() > 0) {
            for (int i = 0; i < this.mTabs.size(); ++i) {
                this.mTabs.get(i).getTitleView().setTypeface(Typeface.create((String)this.mFontFamily, (int)this.mFontStyle));
            }
        }
    }

    public void setShadowHeight(int height) {
        this.SHADOW_HEIGHT = height;
        FrameLayout.LayoutParams lpShadow = new FrameLayout.LayoutParams(-1, this.dpToPixels(height));
        lpShadow.gravity = 80;
        this.mShadowView.setLayoutParams((ViewGroup.LayoutParams)lpShadow);
    }

    public void setBottomNavigationListener(BottomNavigationListener listener) {
        this.mListener = listener;
    }

    void dispatchOnTabSelected(int index) {
        if (this.mListener != null) {
            this.mListener.onTabSelected(index);
        }
    }

    void dispatchOnTabReSelected(int index) {
        if (this.mListener != null) {
            this.mListener.onTabReSelected(index);
        }
    }

    public void addView(View child) {
        if (this.getChildCount() < 2) {
            super.addView(child);
        } else {
            BottomNavigationLayout.logSkippedAddView();
        }
    }

    public void addView(View child, int index) {
        if (this.getChildCount() < 2) {
            super.addView(child, index);
        } else {
            BottomNavigationLayout.logSkippedAddView();
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() < 2) {
            super.addView(child, index, params);
        } else {
            BottomNavigationLayout.logSkippedAddView();
        }
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() < 2) {
            super.addView(child, params);
        } else {
            BottomNavigationLayout.logSkippedAddView();
        }
    }

    public void addView(View child, int width, int height) {
        if (this.getChildCount() < 2) {
            super.addView(child, width, height);
        } else {
            BottomNavigationLayout.logSkippedAddView();
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.LayoutParams && super.checkLayoutParams(p);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -1);
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.LayoutParams ? new ViewGroup.LayoutParams(p) : (p instanceof ViewGroup.MarginLayoutParams ? new ViewGroup.LayoutParams((ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)p)) : new ViewGroup.LayoutParams(p));
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.LayoutParams(this.getContext(), attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        View content = this.getChildAt(0);
        View tabbar = this.getChildAt(1);
        if (content.getVisibility() != 8) {
            content.layout(0, 0, content.getMeasuredWidth(), content.getMeasuredHeight());
        }
        if (tabbar.getVisibility() != 8) {
            tabbar.layout(0, content.getMeasuredHeight(), tabbar.getMeasuredWidth(), b - t);
        }
        this.mInLayout = false;
        this.mFirstLayout = false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            if (this.isInEditMode()) {
                if (widthMode == Integer.MIN_VALUE) {
                    widthMode = 0x40000000;
                } else if (widthMode == 0) {
                    widthMode = 0x40000000;
                    widthSize = 300;
                }
                if (heightMode == Integer.MIN_VALUE) {
                    heightMode = 0x40000000;
                } else if (heightMode == 0) {
                    heightMode = 0x40000000;
                    heightSize = 300;
                }
            } else {
                throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
            }
        }
        this.setMeasuredDimension(widthSize, heightSize);
        View content = this.getChildAt(0);
        View tabbar = this.getChildAt(1);
        content.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(heightSize - this.dpToPixels(56)), (int)0x40000000));
        tabbar.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.dpToPixels(56), (int)0x40000000));
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    private static void logSkippedAddView() {
        Log.w((String)TAG, (String)"BottomNavigationLayout already has 2 children, addView() is a no-op");
    }

    private int dpToPixels(int dp) {
        return (int)((float)dp * this.mDensity + 0.5f);
    }

    private Drawable getShadowDrawable() {
        GradientDrawable gd = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{0xD000000, 0});
        gd.setGradientType(0);
        return gd;
    }

    private class Tab
    extends FrameLayout {
        private static final int ICON_INDEX = 0;
        private static final int TITLE_INDEX = 1;
        private String mTitle;
        private int mIconRes;
        private TextView mTitleView;
        private AppCompatImageView mDrawable;
        private int position;

        private Tab(Context context, String title, String iconName, int index) {
            super(context);
            this.position = -1;
            this.mTitle = title;
            this.mIconRes = context.getResources().getIdentifier(iconName, "drawable", context.getPackageName());
            this.position = index;
            this.init(context);
        }

        private Tab(Context context, @DrawableRes String title, int iconRes, int index) {
            super(context);
            this.position = -1;
            this.mTitle = title;
            this.mIconRes = iconRes;
            this.position = index;
            this.init(context);
        }

        private Tab(@StringRes Context context, @DrawableRes int titleRes, int iconRes, int index) {
            super(context);
            this.position = -1;
            this.mTitle = context.getString(titleRes);
            this.mIconRes = iconRes;
            this.position = index;
            this.init(context);
        }

        private void init(Context context) {
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, BottomNavigationLayout.this.dpToPixels(56)));
            this.setClickable(true);
            this.mTitleView = new TextView(context);
            this.mDrawable = new AppCompatImageView(context);
            FrameLayout.LayoutParams lpTitle = new FrameLayout.LayoutParams(-2, -2);
            FrameLayout.LayoutParams lpIcon = new FrameLayout.LayoutParams(-2, -2);
            lpTitle.gravity = 81;
            this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)lpTitle);
            lpIcon.gravity = 49;
            this.mDrawable.setLayoutParams((ViewGroup.LayoutParams)lpIcon);
            this.mTitleView.setTypeface(Typeface.create((String)BottomNavigationLayout.this.mFontFamily, (int)0));
            this.mTitleView.setText((CharSequence)this.mTitle);
            this.mTitleView.setSingleLine(true);
            this.mTitleView.setMaxLines(1);
            if (this.mIconRes != 0) {
                this.mDrawable.setImageResource(this.mIconRes);
            }
            this.addView((View)this.mDrawable, 0);
            this.addView((View)this.mTitleView, 1);
        }

        private void select() {
            if (BottomNavigationLayout.this.mMode == 2) {
                if (this.getChildCount() == 1) {
                    this.addView((View)this.mTitleView, 1);
                }
                this.setPadding(BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(6), BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(10));
                this.mDrawable.setPadding(0, 0, 0, BottomNavigationLayout.this.dpToPixels(6));
            } else {
                this.setPadding(BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(6), BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(10));
            }
            this.setTintActive();
            this.setFontSize(true);
            if (BottomNavigationLayout.this.mEnv == 1) {
                BottomNavigationLayout.this.mTabsContainer.requestLayout();
            }
        }

        private void deselect() {
            if (BottomNavigationLayout.this.mMode == 2) {
                this.removeViewAt(1);
                this.setPadding(BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(16), BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(10));
                this.mDrawable.setPadding(0, 0, 0, 0);
            } else {
                this.setPadding(BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(8), BottomNavigationLayout.this.dpToPixels(12), BottomNavigationLayout.this.dpToPixels(10));
            }
            this.setTintInactive();
            this.setFontSize(false);
            if (BottomNavigationLayout.this.mEnv == 1) {
                BottomNavigationLayout.this.mTabsContainer.requestLayout();
            }
        }

        private void setWidth(int width) {
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, BottomNavigationLayout.this.dpToPixels(56)));
        }

        private void setFontSize(boolean isSelected) {
            if (BottomNavigationLayout.this.mMode != 2) {
                if (isSelected) {
                    this.mTitleView.setTextSize((float)BottomNavigationLayout.this.FONT_SIZE_ACTIVE_FIXED);
                } else {
                    this.mTitleView.setTextSize((float)BottomNavigationLayout.this.FONT_SIZE_INACTIVE_FIXED);
                }
            } else {
                this.mTitleView.setTextSize((float)BottomNavigationLayout.this.FONT_SIZE_SHIFTING);
            }
        }

        private TextView getTitleView() {
            return this.mTitleView;
        }

        private void setTintActive() {
            if (BottomNavigationLayout.this.mActiveTabTintColor != null) {
                this.mTitleView.setTextColor(Color.parseColor((String)BottomNavigationLayout.this.mActiveTabTintColor));
                this.mDrawable.setColorFilter(Color.parseColor((String)BottomNavigationLayout.this.mActiveTabTintColor));
            }
        }

        private void setTintInactive() {
            if (BottomNavigationLayout.this.mInactiveTabTintColor != null) {
                this.mTitleView.setTextColor(Color.parseColor((String)BottomNavigationLayout.this.mInactiveTabTintColor));
                this.mDrawable.setColorFilter(Color.parseColor((String)BottomNavigationLayout.this.mInactiveTabTintColor));
            }
        }

        private int getPosition() {
            return this.position;
        }

        private Drawable getIcon() {
            return this.mDrawable.getDrawable();
        }

        private int getIconRes() {
            return this.mIconRes;
        }

        private String getTitle() {
            return this.mTitle;
        }
    }

    public static abstract class SimpleBottomNavigationListener
    implements BottomNavigationListener {
        @Override
        public void onTabReSelected(int position) {
        }

        @Override
        public void onTabSelected(int position) {
        }
    }

    public static interface BottomNavigationListener {
        public void onTabSelected(int var1);

        public void onTabReSelected(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Env {
    }
}

