package com.docusign.rooms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** RoomUsersResult. */
public class RoomUsersResult {
  @JsonProperty("users")
  private java.util.List<RoomUserSummary> users = null;

  @JsonProperty("resultSetSize")
  private Integer resultSetSize = null;

  @JsonProperty("startPosition")
  private Integer startPosition = null;

  @JsonProperty("endPosition")
  private Integer endPosition = null;

  @JsonProperty("nextUri")
  private String nextUri = null;

  @JsonProperty("priorUri")
  private String priorUri = null;

  @JsonProperty("totalRowCount")
  private Integer totalRowCount = null;

  /**
   * users.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult users(java.util.List<RoomUserSummary> users) {
    this.users = users;
    return this;
  }

  /**
   * addUsersItem.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult addUsersItem(RoomUserSummary usersItem) {
    if (this.users == null) {
      this.users = new java.util.ArrayList<>();
    }
    this.users.add(usersItem);
    return this;
  }

  /**
   * Get users.
   *
   * @return users
   */
  @Schema(description = "")
  public java.util.List<RoomUserSummary> getUsers() {
    return users;
  }

  /** setUsers. */
  public void setUsers(java.util.List<RoomUserSummary> users) {
    this.users = users;
  }

  /**
   * resultSetSize.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult resultSetSize(Integer resultSetSize) {
    this.resultSetSize = resultSetSize;
    return this;
  }

  /**
   * Get resultSetSize.
   *
   * @return resultSetSize
   */
  @Schema(description = "")
  public Integer getResultSetSize() {
    return resultSetSize;
  }

  /** setResultSetSize. */
  public void setResultSetSize(Integer resultSetSize) {
    this.resultSetSize = resultSetSize;
  }

  /**
   * startPosition.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult startPosition(Integer startPosition) {
    this.startPosition = startPosition;
    return this;
  }

  /**
   * Get startPosition.
   *
   * @return startPosition
   */
  @Schema(description = "")
  public Integer getStartPosition() {
    return startPosition;
  }

  /** setStartPosition. */
  public void setStartPosition(Integer startPosition) {
    this.startPosition = startPosition;
  }

  /**
   * Get endPosition.
   *
   * @return endPosition
   */
  @Schema(description = "")
  public Integer getEndPosition() {
    return endPosition;
  }

  /**
   * nextUri.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult nextUri(String nextUri) {
    this.nextUri = nextUri;
    return this;
  }

  /**
   * Get nextUri.
   *
   * @return nextUri
   */
  @Schema(description = "")
  public String getNextUri() {
    return nextUri;
  }

  /** setNextUri. */
  public void setNextUri(String nextUri) {
    this.nextUri = nextUri;
  }

  /**
   * priorUri.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult priorUri(String priorUri) {
    this.priorUri = priorUri;
    return this;
  }

  /**
   * Get priorUri.
   *
   * @return priorUri
   */
  @Schema(description = "")
  public String getPriorUri() {
    return priorUri;
  }

  /** setPriorUri. */
  public void setPriorUri(String priorUri) {
    this.priorUri = priorUri;
  }

  /**
   * totalRowCount.
   *
   * @return RoomUsersResult
   */
  public RoomUsersResult totalRowCount(Integer totalRowCount) {
    this.totalRowCount = totalRowCount;
    return this;
  }

  /**
   * Get totalRowCount.
   *
   * @return totalRowCount
   */
  @Schema(description = "")
  public Integer getTotalRowCount() {
    return totalRowCount;
  }

  /** setTotalRowCount. */
  public void setTotalRowCount(Integer totalRowCount) {
    this.totalRowCount = totalRowCount;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomUsersResult roomUsersResult = (RoomUsersResult) o;
    return Objects.equals(this.users, roomUsersResult.users)
        && Objects.equals(this.resultSetSize, roomUsersResult.resultSetSize)
        && Objects.equals(this.startPosition, roomUsersResult.startPosition)
        && Objects.equals(this.endPosition, roomUsersResult.endPosition)
        && Objects.equals(this.nextUri, roomUsersResult.nextUri)
        && Objects.equals(this.priorUri, roomUsersResult.priorUri)
        && Objects.equals(this.totalRowCount, roomUsersResult.totalRowCount);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(
        users, resultSetSize, startPosition, endPosition, nextUri, priorUri, totalRowCount);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomUsersResult {\n");

    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    resultSetSize: ").append(toIndentedString(resultSetSize)).append("\n");
    sb.append("    startPosition: ").append(toIndentedString(startPosition)).append("\n");
    sb.append("    endPosition: ").append(toIndentedString(endPosition)).append("\n");
    sb.append("    nextUri: ").append(toIndentedString(nextUri)).append("\n");
    sb.append("    priorUri: ").append(toIndentedString(priorUri)).append("\n");
    sb.append("    totalRowCount: ").append(toIndentedString(totalRowCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
