package com.docusign.rooms.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Gets or Sets RoomUserSortingOption */
public enum RoomUserSortingOption {
  FIRSTNAMEASC("FirstNameAsc"),

  LASTNAMEASC("LastNameAsc"),

  EMAILASC("EmailAsc"),

  FIRSTNAMEDESC("FirstNameDesc"),

  LASTNAMEDESC("LastNameDesc"),

  EMAILDESC("EmailDesc");

  private String value;

  RoomUserSortingOption(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static RoomUserSortingOption fromValue(String value) {
    for (RoomUserSortingOption b : RoomUserSortingOption.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }
}
