package com.docusign.rooms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** RoomFolderList. */
public class RoomFolderList {
  @JsonProperty("folders")
  private java.util.List<RoomFolder> folders = null;

  @JsonProperty("resultSetSize")
  private Integer resultSetSize = null;

  @JsonProperty("startPosition")
  private Integer startPosition = null;

  @JsonProperty("endPosition")
  private Integer endPosition = null;

  @JsonProperty("nextUri")
  private String nextUri = null;

  @JsonProperty("priorUri")
  private String priorUri = null;

  @JsonProperty("totalRowCount")
  private Integer totalRowCount = null;

  /**
   * folders.
   *
   * @return RoomFolderList
   */
  public RoomFolderList folders(java.util.List<RoomFolder> folders) {
    this.folders = folders;
    return this;
  }

  /**
   * addFoldersItem.
   *
   * @return RoomFolderList
   */
  public RoomFolderList addFoldersItem(RoomFolder foldersItem) {
    if (this.folders == null) {
      this.folders = new java.util.ArrayList<>();
    }
    this.folders.add(foldersItem);
    return this;
  }

  /**
   * Get folders.
   *
   * @return folders
   */
  @Schema(description = "")
  public java.util.List<RoomFolder> getFolders() {
    return folders;
  }

  /** setFolders. */
  public void setFolders(java.util.List<RoomFolder> folders) {
    this.folders = folders;
  }

  /**
   * resultSetSize.
   *
   * @return RoomFolderList
   */
  public RoomFolderList resultSetSize(Integer resultSetSize) {
    this.resultSetSize = resultSetSize;
    return this;
  }

  /**
   * Get resultSetSize.
   *
   * @return resultSetSize
   */
  @Schema(description = "")
  public Integer getResultSetSize() {
    return resultSetSize;
  }

  /** setResultSetSize. */
  public void setResultSetSize(Integer resultSetSize) {
    this.resultSetSize = resultSetSize;
  }

  /**
   * startPosition.
   *
   * @return RoomFolderList
   */
  public RoomFolderList startPosition(Integer startPosition) {
    this.startPosition = startPosition;
    return this;
  }

  /**
   * Get startPosition.
   *
   * @return startPosition
   */
  @Schema(description = "")
  public Integer getStartPosition() {
    return startPosition;
  }

  /** setStartPosition. */
  public void setStartPosition(Integer startPosition) {
    this.startPosition = startPosition;
  }

  /**
   * Get endPosition.
   *
   * @return endPosition
   */
  @Schema(description = "")
  public Integer getEndPosition() {
    return endPosition;
  }

  /**
   * nextUri.
   *
   * @return RoomFolderList
   */
  public RoomFolderList nextUri(String nextUri) {
    this.nextUri = nextUri;
    return this;
  }

  /**
   * Get nextUri.
   *
   * @return nextUri
   */
  @Schema(description = "")
  public String getNextUri() {
    return nextUri;
  }

  /** setNextUri. */
  public void setNextUri(String nextUri) {
    this.nextUri = nextUri;
  }

  /**
   * priorUri.
   *
   * @return RoomFolderList
   */
  public RoomFolderList priorUri(String priorUri) {
    this.priorUri = priorUri;
    return this;
  }

  /**
   * Get priorUri.
   *
   * @return priorUri
   */
  @Schema(description = "")
  public String getPriorUri() {
    return priorUri;
  }

  /** setPriorUri. */
  public void setPriorUri(String priorUri) {
    this.priorUri = priorUri;
  }

  /**
   * totalRowCount.
   *
   * @return RoomFolderList
   */
  public RoomFolderList totalRowCount(Integer totalRowCount) {
    this.totalRowCount = totalRowCount;
    return this;
  }

  /**
   * Get totalRowCount.
   *
   * @return totalRowCount
   */
  @Schema(description = "")
  public Integer getTotalRowCount() {
    return totalRowCount;
  }

  /** setTotalRowCount. */
  public void setTotalRowCount(Integer totalRowCount) {
    this.totalRowCount = totalRowCount;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomFolderList roomFolderList = (RoomFolderList) o;
    return Objects.equals(this.folders, roomFolderList.folders)
        && Objects.equals(this.resultSetSize, roomFolderList.resultSetSize)
        && Objects.equals(this.startPosition, roomFolderList.startPosition)
        && Objects.equals(this.endPosition, roomFolderList.endPosition)
        && Objects.equals(this.nextUri, roomFolderList.nextUri)
        && Objects.equals(this.priorUri, roomFolderList.priorUri)
        && Objects.equals(this.totalRowCount, roomFolderList.totalRowCount);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(
        folders, resultSetSize, startPosition, endPosition, nextUri, priorUri, totalRowCount);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomFolderList {\n");

    sb.append("    folders: ").append(toIndentedString(folders)).append("\n");
    sb.append("    resultSetSize: ").append(toIndentedString(resultSetSize)).append("\n");
    sb.append("    startPosition: ").append(toIndentedString(startPosition)).append("\n");
    sb.append("    endPosition: ").append(toIndentedString(endPosition)).append("\n");
    sb.append("    nextUri: ").append(toIndentedString(nextUri)).append("\n");
    sb.append("    priorUri: ").append(toIndentedString(priorUri)).append("\n");
    sb.append("    totalRowCount: ").append(toIndentedString(totalRowCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
