package com.docusign.rooms.api;

import com.docusign.rooms.client.ApiClient;
import com.docusign.rooms.client.ApiException;
import com.docusign.rooms.client.ApiResponse;
import com.docusign.rooms.client.Configuration;
import com.docusign.rooms.client.Pair;
import com.docusign.rooms.model.*;
import jakarta.ws.rs.core.GenericType;

/** FormDetailsApi class. */
public class FormDetailsApi {
  private ApiClient apiClient;

  /** FormDetailsApi. */
  public FormDetailsApi() {
    this(Configuration.getDefaultApiClient());
  }

  /** FormDetailsApi. */
  public FormDetailsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * getApiClient Method.
   *
   * @return ApiClient
   */
  public ApiClient getApiClient() {
    return apiClient;
  }

  /** setApiClient Method. */
  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Gets form based on Id.. Returns details about a specific form, such as the date it was created
   * and last updated, the number of pages, the form owner, and other information.
   *
   * @param accountId (Required) The globally unique identifier (GUID) for the account. (required)
   * @param formId Form ID (required)
   * @return FormDetails
   * @throws ApiException if fails to make API call
   */
  public FormDetails getFormDetails(String accountId, java.util.UUID formId) throws ApiException {
    ApiResponse<FormDetails> localVarResponse = getFormDetailsWithHttpInfo(accountId, formId);
    return localVarResponse.getData();
  }

  /**
   * Gets form based on Id. Returns details about a specific form, such as the date it was created
   * and last updated, the number of pages, the form owner, and other information.
   *
   * @param accountId (Required) The globally unique identifier (GUID) for the account. (required)
   * @param formId Form ID (required)
   * @return FormDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<FormDetails> getFormDetailsWithHttpInfo(
      String accountId, java.util.UUID formId) throws ApiException {
    Object localVarPostBody = "{}";

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'accountId' when calling getFormDetails");
    }

    // verify the required parameter 'formId' is set
    if (formId == null) {
      throw new ApiException(
          400, "Missing the required parameter 'formId' when calling getFormDetails");
    }

    // create path and map variables
    String localVarPath =
        "/v2/accounts/{accountId}/forms/{formId}/details"
            .replaceAll("\\{" + "accountId" + "\\}", apiClient.escapeString(accountId.toString()))
            .replaceAll("\\{" + "formId" + "\\}", apiClient.escapeString(formId.toString()));

    // query params
    java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
    java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();
    java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
    java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

    final String[] localVarAccepts = {
      "text/plain", "application/json", "text/json", "application/xml", "text/xml"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json-patch+json", "application/json", "text/json", "application/_*+json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {"docusignAccessCode"};

    GenericType<FormDetails> localVarReturnType = new GenericType<FormDetails>() {};
    FormDetails localVarResponse =
        apiClient.invokeAPI(
            localVarPath,
            "GET",
            localVarQueryParams,
            localVarCollectionQueryParams,
            localVarPostBody,
            localVarHeaderParams,
            localVarFormParams,
            localVarAccept,
            localVarContentType,
            localVarAuthNames,
            localVarReturnType);
    return new ApiResponse<FormDetails>(
        apiClient.getStatusCode(), apiClient.getResponseHeaders(), localVarResponse);
  }
}
