/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about the price and currency associated with the feature set. Reserved for internal DocuSign use only.")
public class CurrencyFeatureSetPrice {
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;
    @JsonProperty(value="currencySymbol")
    private String currencySymbol = null;
    @JsonProperty(value="envelopeFee")
    private String envelopeFee = null;
    @JsonProperty(value="fixedFee")
    private String fixedFee = null;
    @JsonProperty(value="seatFee")
    private String seatFee = null;

    public CurrencyFeatureSetPrice currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="Specifies the alternate ISO currency code for the account. ")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CurrencyFeatureSetPrice currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    @Schema(description="Specifies the alternate currency symbol for the account.")
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public CurrencyFeatureSetPrice envelopeFee(String envelopeFee) {
        this.envelopeFee = envelopeFee;
        return this;
    }

    @Schema(description="An incremental envelope cost for plans with envelope overages (when `isEnabled` is set to **true**.)")
    public String getEnvelopeFee() {
        return this.envelopeFee;
    }

    public void setEnvelopeFee(String envelopeFee) {
        this.envelopeFee = envelopeFee;
    }

    public CurrencyFeatureSetPrice fixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
        return this;
    }

    @Schema(description="Specifies a one-time fee associated with the plan (when `isEnabled` is set to **true**.)")
    public String getFixedFee() {
        return this.fixedFee;
    }

    public void setFixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
    }

    public CurrencyFeatureSetPrice seatFee(String seatFee) {
        this.seatFee = seatFee;
        return this;
    }

    @Schema(description="Specifies an incremental seat cost for seat-based plans (when `isEnabled` is set to **true**.)")
    public String getSeatFee() {
        return this.seatFee;
    }

    public void setSeatFee(String seatFee) {
        this.seatFee = seatFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrencyFeatureSetPrice currencyFeatureSetPrice = (CurrencyFeatureSetPrice)o;
        return Objects.equals(this.currencyCode, currencyFeatureSetPrice.currencyCode) && Objects.equals(this.currencySymbol, currencyFeatureSetPrice.currencySymbol) && Objects.equals(this.envelopeFee, currencyFeatureSetPrice.envelopeFee) && Objects.equals(this.fixedFee, currencyFeatureSetPrice.fixedFee) && Objects.equals(this.seatFee, currencyFeatureSetPrice.seatFee);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.currencySymbol, this.envelopeFee, this.fixedFee, this.seatFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrencyFeatureSetPrice {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    currencySymbol: ").append(this.toIndentedString(this.currencySymbol)).append("\n");
        sb.append("    envelopeFee: ").append(this.toIndentedString(this.envelopeFee)).append("\n");
        sb.append("    fixedFee: ").append(this.toIndentedString(this.fixedFee)).append("\n");
        sb.append("    seatFee: ").append(this.toIndentedString(this.seatFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

