/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.page;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.AppAdapter;
import org.wikipedia.dataclient.page.PageLeadProperties;
import org.wikipedia.page.GeoMarshaller;
import org.wikipedia.page.GeoUnmarshaller;
import org.wikipedia.page.Namespace;
import org.wikipedia.page.PageTitle;
import org.wikipedia.util.DateUtil;

public class PageProperties
implements Parcelable {
    private final int pageId;
    @NonNull
    private final Namespace namespace;
    private final long revisionId;
    private final Date lastModified;
    private final String displayTitleText;
    private final String editProtectionStatus;
    private final int languageCount;
    private final boolean isMainPage;
    private final boolean isDisambiguationPage;
    @Nullable
    private final String leadImageUrl;
    @Nullable
    private final String leadImageName;
    @Nullable
    private final String titlePronunciationUrl;
    @Nullable
    private final Location geo;
    @Nullable
    private final String wikiBaseItem;
    @Nullable
    private final String descriptionSource;
    private final boolean canEdit;
    public static final Parcelable.Creator<PageProperties> CREATOR = new Parcelable.Creator<PageProperties>(){

        public PageProperties createFromParcel(Parcel in) {
            return new PageProperties(in);
        }

        public PageProperties[] newArray(int size) {
            return new PageProperties[size];
        }
    };

    public PageProperties(PageLeadProperties core) {
        this.pageId = core.getId();
        this.namespace = core.getNamespace();
        this.revisionId = core.getRevision();
        this.displayTitleText = StringUtils.defaultString((String)core.getDisplayTitle());
        this.titlePronunciationUrl = core.getTitlePronunciationUrl();
        this.geo = core.getGeo();
        this.editProtectionStatus = core.getFirstAllowedEditorRole();
        this.languageCount = core.getLanguageCount();
        this.leadImageUrl = core.getLeadImageUrl(AppAdapter.get().getDesiredLeadImageDp());
        this.leadImageName = core.getLeadImageFileName();
        this.lastModified = new Date();
        String lastModifiedText = core.getLastModified();
        if (lastModifiedText != null) {
            try {
                this.lastModified.setTime(DateUtil.getIso8601DateFormat().parse(lastModifiedText).getTime());
            }
            catch (ParseException e) {
                Log.d((String)"PageProperties", (String)("Failed to parse date: " + lastModifiedText));
            }
        }
        this.canEdit = core.isEditable();
        this.isMainPage = core.isMainPage();
        this.isDisambiguationPage = core.isDisambiguation();
        this.wikiBaseItem = core.getWikiBaseItem();
        this.descriptionSource = core.getDescriptionSource();
    }

    public PageProperties(@NonNull PageTitle title, boolean isMainPage) {
        this.pageId = 0;
        this.namespace = title.namespace();
        this.revisionId = 0L;
        this.displayTitleText = title.getDisplayText();
        this.titlePronunciationUrl = null;
        this.geo = null;
        this.editProtectionStatus = "";
        this.languageCount = 1;
        this.leadImageUrl = null;
        this.leadImageName = "";
        this.lastModified = new Date();
        this.canEdit = false;
        this.isMainPage = isMainPage;
        this.isDisambiguationPage = false;
        this.wikiBaseItem = null;
        this.descriptionSource = null;
    }

    public int getPageId() {
        return this.pageId;
    }

    @NonNull
    public Namespace getNamespace() {
        return this.namespace;
    }

    public long getRevisionId() {
        return this.revisionId;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getDisplayTitle() {
        return this.displayTitleText;
    }

    @Nullable
    public String getTitlePronunciationUrl() {
        return this.titlePronunciationUrl;
    }

    @Nullable
    public Location getGeo() {
        return this.geo;
    }

    public String getEditProtectionStatus() {
        return this.editProtectionStatus;
    }

    public int getLanguageCount() {
        return this.languageCount;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public boolean isMainPage() {
        return this.isMainPage;
    }

    public boolean isDisambiguationPage() {
        return this.isDisambiguationPage;
    }

    @Nullable
    public String getLeadImageUrl() {
        return this.leadImageUrl;
    }

    @Nullable
    public String getLeadImageName() {
        return this.leadImageName;
    }

    @Nullable
    public String getWikiBaseItem() {
        return this.wikiBaseItem;
    }

    @Nullable
    public String getDescriptionSource() {
        return this.descriptionSource;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.pageId);
        parcel.writeInt(this.namespace.code());
        parcel.writeLong(this.revisionId);
        parcel.writeLong(this.lastModified.getTime());
        parcel.writeString(this.displayTitleText);
        parcel.writeString(this.titlePronunciationUrl);
        parcel.writeString(GeoMarshaller.marshal(this.geo));
        parcel.writeString(this.editProtectionStatus);
        parcel.writeInt(this.languageCount);
        parcel.writeInt(this.canEdit ? 1 : 0);
        parcel.writeInt(this.isMainPage ? 1 : 0);
        parcel.writeInt(this.isDisambiguationPage ? 1 : 0);
        parcel.writeString(this.leadImageUrl);
        parcel.writeString(this.leadImageName);
        parcel.writeString(this.wikiBaseItem);
        parcel.writeString(this.descriptionSource);
    }

    private PageProperties(Parcel in) {
        this.pageId = in.readInt();
        this.namespace = Namespace.of(in.readInt());
        this.revisionId = in.readLong();
        this.lastModified = new Date(in.readLong());
        this.displayTitleText = in.readString();
        this.titlePronunciationUrl = in.readString();
        this.geo = GeoUnmarshaller.unmarshal(in.readString());
        this.editProtectionStatus = in.readString();
        this.languageCount = in.readInt();
        this.canEdit = in.readInt() == 1;
        this.isMainPage = in.readInt() == 1;
        this.isDisambiguationPage = in.readInt() == 1;
        this.leadImageUrl = in.readString();
        this.leadImageName = in.readString();
        this.wikiBaseItem = in.readString();
        this.descriptionSource = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageProperties that = (PageProperties)o;
        return this.pageId == that.pageId && this.namespace == that.namespace && this.revisionId == that.revisionId && this.lastModified.equals(that.lastModified) && this.displayTitleText.equals(that.displayTitleText) && TextUtils.equals((CharSequence)this.titlePronunciationUrl, (CharSequence)that.titlePronunciationUrl) && (this.geo == that.geo || this.geo != null && this.geo.equals(that.geo)) && this.languageCount == that.languageCount && this.canEdit == that.canEdit && this.isMainPage == that.isMainPage && this.isDisambiguationPage == that.isDisambiguationPage && TextUtils.equals((CharSequence)this.editProtectionStatus, (CharSequence)that.editProtectionStatus) && TextUtils.equals((CharSequence)this.leadImageUrl, (CharSequence)that.leadImageUrl) && TextUtils.equals((CharSequence)this.leadImageName, (CharSequence)that.leadImageName) && TextUtils.equals((CharSequence)this.wikiBaseItem, (CharSequence)that.wikiBaseItem);
    }

    public int hashCode() {
        int result = this.lastModified.hashCode();
        result = 31 * result + this.displayTitleText.hashCode();
        result = 31 * result + (this.titlePronunciationUrl != null ? this.titlePronunciationUrl.hashCode() : 0);
        result = 31 * result + (this.geo != null ? this.geo.hashCode() : 0);
        result = 31 * result + (this.editProtectionStatus != null ? this.editProtectionStatus.hashCode() : 0);
        result = 31 * result + this.languageCount;
        result = 31 * result + (this.isMainPage ? 1 : 0);
        result = 31 * result + (this.isDisambiguationPage ? 1 : 0);
        result = 31 * result + (this.leadImageUrl != null ? this.leadImageUrl.hashCode() : 0);
        result = 31 * result + (this.leadImageName != null ? this.leadImageName.hashCode() : 0);
        result = 31 * result + (this.wikiBaseItem != null ? this.wikiBaseItem.hashCode() : 0);
        result = 31 * result + (this.canEdit ? 1 : 0);
        result = 31 * result + this.pageId;
        result = 31 * result + this.namespace.code();
        result = 31 * result + (int)this.revisionId;
        return result;
    }
}

