/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.notifications;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.json.GsonUtil;
import org.wikipedia.util.DateUtil;
import org.wikipedia.util.log.L;

public class Notification {
    public static final String TYPE_EDIT_USER_TALK = "edit-user-talk";
    public static final String TYPE_REVERTED = "reverted";
    public static final String TYPE_EDIT_THANK = "edit-thank";
    public static final String TYPE_WELCOME = "welcome";
    public static final String TYPE_EDIT_MILESTONE = "thank-you-edit";
    public static final String TYPE_LOGIN_SUCCESS = "login-success";
    public static final String TYPE_LOGIN_FAIL_NEW = "login-fail-new";
    public static final String TYPE_LOGIN_FAIL_KNOWN = "login-fail-known";
    public static final String TYPE_FOREIGN = "foreign";
    @Nullable
    private String wiki;
    private long id;
    @Nullable
    private String type;
    @Nullable
    private String category;
    private long revid;
    @Nullable
    private Title title;
    @Nullable
    private Agent agent;
    @Nullable
    private Timestamp timestamp;
    @SerializedName(value="*")
    @Nullable
    private Contents contents;
    @Nullable
    private Map<String, Source> sources;

    @NonNull
    public String wiki() {
        return StringUtils.defaultString((String)this.wiki);
    }

    public long id() {
        return this.id;
    }

    public long key() {
        return this.id + (long)this.wiki().hashCode();
    }

    @NonNull
    public String type() {
        return StringUtils.defaultString((String)this.type);
    }

    @Nullable
    public Agent agent() {
        return this.agent;
    }

    @Nullable
    public Title title() {
        return this.title;
    }

    public long revID() {
        return this.revid;
    }

    @Nullable
    Contents getContents() {
        return this.contents;
    }

    @NonNull
    Date getTimestamp() {
        return this.timestamp != null ? this.timestamp.date() : new Date();
    }

    @NonNull
    String getUtcIso8601() {
        return StringUtils.defaultString(this.timestamp != null ? this.timestamp.utciso8601 : null);
    }

    @Nullable
    Map<String, Source> getSources() {
        return this.sources;
    }

    public boolean isFromWikidata() {
        return this.wiki().equals("wikidatawiki");
    }

    public String toString() {
        return Long.toString(this.id);
    }

    public static class SeenTime {
        @Nullable
        private String alert;
        @Nullable
        private String message;

        @Nullable
        public String getAlert() {
            return this.alert;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }
    }

    public static class UnreadNotificationWikiItem {
        private int totalCount;
        @Nullable
        private Source source;

        public int getTotalCount() {
            return this.totalCount;
        }

        @Nullable
        public Source getSource() {
            return this.source;
        }
    }

    public static class Contents {
        @Nullable
        private String header;
        @Nullable
        private String compactHeader;
        @Nullable
        private String body;
        @Nullable
        private String icon;
        @Nullable
        private String iconUrl;
        @Nullable
        private Links links;

        @NonNull
        public String getHeader() {
            return StringUtils.defaultString((String)this.header);
        }

        @NonNull
        public String getCompactHeader() {
            return StringUtils.defaultString((String)this.compactHeader);
        }

        @NonNull
        public String getBody() {
            return StringUtils.defaultString((String)this.body);
        }

        @NonNull
        public String getIconUrl() {
            return StringUtils.defaultString((String)this.iconUrl);
        }

        @Nullable
        public Links getLinks() {
            return this.links;
        }
    }

    public static class Source {
        @Nullable
        private String title;
        @Nullable
        private String url;
        @Nullable
        private String base;

        @NonNull
        public String getTitle() {
            return StringUtils.defaultString((String)this.title);
        }

        @NonNull
        public String getUrl() {
            return StringUtils.defaultString((String)this.url);
        }

        @NonNull
        public String getBase() {
            return StringUtils.defaultString((String)this.base);
        }
    }

    public static class Links {
        @Nullable
        private JsonElement primary;
        @Nullable
        private List<Link> secondary;
        private Link primaryLink;

        @Nullable
        public Link getPrimary() {
            if (this.primary == null) {
                return null;
            }
            if (this.primaryLink == null && this.primary instanceof JsonObject) {
                this.primaryLink = (Link)GsonUtil.getDefaultGson().fromJson(this.primary, Link.class);
            }
            return this.primaryLink;
        }

        @Nullable
        public List<Link> getSecondary() {
            return this.secondary;
        }
    }

    public static class Link {
        @Nullable
        private String url;
        @Nullable
        private String label;
        @Nullable
        private String tooltip;
        @Nullable
        private String description;
        @Nullable
        private String icon;

        @NonNull
        public String getUrl() {
            return StringUtils.defaultString((String)this.url);
        }

        @NonNull
        public String getTooltip() {
            return StringUtils.defaultString((String)this.tooltip);
        }

        @NonNull
        public String getLabel() {
            return StringUtils.defaultString((String)this.label);
        }

        @NonNull
        public String getIcon() {
            return StringUtils.defaultString((String)this.icon);
        }
    }

    public static class Timestamp {
        @Nullable
        private String utciso8601;

        public Date date() {
            try {
                return DateUtil.getIso8601DateFormat().parse(this.utciso8601);
            }
            catch (ParseException e) {
                L.e(e);
                return new Date();
            }
        }
    }

    public static class Agent {
        private int id;
        @Nullable
        private String name;

        @NonNull
        public String name() {
            return StringUtils.defaultString((String)this.name);
        }
    }

    public static class Title {
        @Nullable
        private String full;
        @Nullable
        private String text;
        @Nullable
        private String namespace;
        @SerializedName(value="namespace-key")
        private int namespaceKey;

        @NonNull
        public String text() {
            return StringUtils.defaultString((String)this.text);
        }

        @NonNull
        public String full() {
            return StringUtils.defaultString((String)this.full);
        }

        public boolean isMainNamespace() {
            return this.namespaceKey == 0;
        }

        public void setFull(@NonNull String title) {
            this.full = title;
        }
    }
}

