/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.retrofit;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import retrofit2.Response;

public class RetrofitException
extends RuntimeException {
    private final String url;
    @Nullable
    private final Integer code;
    private final Kind kind;

    public static RetrofitException httpError(Response<?> response) {
        return RetrofitException.httpError(response.raw().request().url().toString(), response);
    }

    public static RetrofitException httpError(String url, Response<?> response) {
        String message = response.code() + " " + response.message();
        return new RetrofitException(message, url, response.code(), Kind.HTTP, null);
    }

    public static RetrofitException httpError(@NonNull okhttp3.Response response) {
        String message = response.code() + " " + response.message();
        return new RetrofitException(message, response.request().url().toString(), response.code(), Kind.HTTP, null);
    }

    public static RetrofitException networkError(IOException exception) {
        return new RetrofitException(exception.getMessage(), null, null, Kind.NETWORK, exception);
    }

    public static RetrofitException unexpectedError(Throwable exception) {
        return new RetrofitException(exception.getMessage(), null, null, Kind.UNEXPECTED, exception);
    }

    RetrofitException(String message, String url, @Nullable Integer code, Kind kind, Throwable exception) {
        super(message, exception);
        this.url = url;
        this.code = code;
        this.kind = kind;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public Integer getCode() {
        return this.code;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        NETWORK,
        HTTP,
        UNEXPECTED;

    }
}

