/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.util;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.page.PageTitle;
import org.wikipedia.util.log.L;

public final class UriUtil {
    @NonNull
    public static String decodeURL(@NonNull String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (IllegalArgumentException e) {
            L.d("URL decoding failed. String was: " + url);
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static String encodeURL(@NonNull String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public static String resolveProtocolRelativeUrl(@NonNull WikiSite wiki, @NonNull String url) {
        String ret = UriUtil.resolveProtocolRelativeUrl(url);
        return ret.startsWith("./") || ret.startsWith("/w/") || ret.startsWith("/wiki/") || ret.startsWith("/api/") ? wiki.uri().buildUpon().appendEncodedPath(ret.replaceFirst("/", "")).build().toString() : ret;
    }

    @NonNull
    public static String resolveProtocolRelativeUrl(@NonNull String url) {
        return url.startsWith("//") ? "https:" + url : url;
    }

    public static boolean isValidPageLink(@NonNull Uri uri) {
        return !TextUtils.isEmpty((CharSequence)uri.getAuthority()) && uri.getAuthority().endsWith("wikipedia.org") && !TextUtils.isEmpty((CharSequence)uri.getPath()) && uri.getPath().startsWith("/wiki");
    }

    public static boolean isValidOfflinePageLink(@NonNull Uri uri) {
        return !TextUtils.isEmpty((CharSequence)uri.getAuthority()) && uri.getAuthority().endsWith("wikipedia.org") && !TextUtils.isEmpty((CharSequence)uri.getPath()) && uri.getPath().endsWith(".html");
    }

    public static String getUrlWithProvenance(Context context, PageTitle title, @StringRes int provId) {
        return title.getCanonicalUri() + "?wprov=" + context.getString(provId);
    }

    @NonNull
    public static String getTitleFromUrl(@NonNull String url) {
        return UriUtil.removeFragment(UriUtil.removeLinkPrefix(url)).replace("_", " ");
    }

    @NonNull
    public static String getLanguageVariantFromUri(@NonNull Uri uri) {
        if (TextUtils.isEmpty((CharSequence)uri.getPath())) {
            return "";
        }
        String[] parts = StringUtils.split((String)StringUtils.defaultString((String)uri.getPath()), (char)'/');
        return parts.length > 1 && !parts[0].equals("wiki") ? parts[0] : "";
    }

    @NonNull
    public static String removeInternalLinkPrefix(@NonNull String link) {
        return link.replaceFirst("/wiki/|/zh-.*/", "");
    }

    @NonNull
    private static String removeLinkPrefix(@NonNull String link) {
        return link.replaceFirst("^.*?/wiki/", "");
    }

    @VisibleForTesting
    @NonNull
    static String removeFragment(@NonNull String link) {
        return link.replaceFirst("#.*$", "");
    }

    public static String getFragment(String link) {
        return Uri.parse((String)link).getFragment();
    }

    private UriUtil() {
    }
}

