/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.language;

import androidx.annotation.NonNull;
import java.util.Locale;

public final class AcceptLanguageUtil {
    private static final float APP_LANGUAGE_QUALITY = 0.9f;
    private static final float SYSTEM_LANGUAGE_QUALITY = 0.8f;

    @NonNull
    public static String getAcceptLanguage(@NonNull String wikiLanguageCode, @NonNull String appLanguageCode, @NonNull String systemLanguageCode) {
        String acceptLanguage = wikiLanguageCode;
        acceptLanguage = AcceptLanguageUtil.appendToAcceptLanguage(acceptLanguage, appLanguageCode, 0.9f);
        acceptLanguage = AcceptLanguageUtil.appendToAcceptLanguage(acceptLanguage, systemLanguageCode, 0.8f);
        return acceptLanguage;
    }

    @NonNull
    private static String appendToAcceptLanguage(@NonNull String acceptLanguage, @NonNull String languageCode, float quality) {
        if (acceptLanguage.contains(languageCode)) {
            return acceptLanguage;
        }
        if (acceptLanguage.isEmpty()) {
            return languageCode;
        }
        return String.format(Locale.ROOT, "%s,%s;q=%.1f", acceptLanguage, languageCode, Float.valueOf(quality));
    }

    private AcceptLanguageUtil() {
    }
}

