/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.json;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import org.wikipedia.json.annotations.Required;

class RequiredFieldsCheckOnReadTypeAdapterFactory
implements TypeAdapterFactory {
    RequiredFieldsCheckOnReadTypeAdapterFactory() {
    }

    @Nullable
    public final <T> TypeAdapter<T> create(@NonNull Gson gson, @NonNull TypeToken<T> typeToken) {
        Class rawType = typeToken.getRawType();
        Set<Field> requiredFields = this.collectRequiredFields(rawType);
        if (requiredFields.isEmpty()) {
            return null;
        }
        this.setFieldsAccessible(requiredFields, true);
        return new Adapter(gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken), requiredFields);
    }

    @NonNull
    private Set<Field> collectRequiredFields(@NonNull Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArraySet required = new ArraySet();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Required.class)) continue;
            required.add(field);
        }
        return Collections.unmodifiableSet(required);
    }

    private void setFieldsAccessible(Iterable<Field> fields, boolean accessible) {
        for (Field field : fields) {
            field.setAccessible(accessible);
        }
    }

    private static final class Adapter<T>
    extends TypeAdapter<T> {
        @NonNull
        private final TypeAdapter<T> delegate;
        @NonNull
        private final Set<Field> requiredFields;

        private Adapter(@NonNull TypeAdapter<T> delegate, @NonNull Set<Field> requiredFields) {
            this.delegate = delegate;
            this.requiredFields = requiredFields;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }

        @Nullable
        public T read(JsonReader in) throws IOException {
            Object deserialized = this.delegate.read(in);
            return (T)(this.allRequiredFieldsPresent(deserialized, this.requiredFields) ? deserialized : null);
        }

        private boolean allRequiredFieldsPresent(@NonNull T deserialized, @NonNull Set<Field> required) {
            for (Field field : required) {
                try {
                    if (field.get(deserialized) != null) continue;
                    return false;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return true;
        }
    }
}

