/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.wikipedia.AppAdapter;
import org.wikipedia.util.log.L;

public final class SharedPreferenceCookieManager
implements CookieJar {
    private static final String CENTRALAUTH_PREFIX = "centralauth_";
    private static SharedPreferenceCookieManager INSTANCE;
    private final Map<String, List<Cookie>> cookieJar;

    @NonNull
    public static SharedPreferenceCookieManager getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = AppAdapter.get().getCookies();
            }
            catch (Exception e) {
                L.logRemoteErrorIfProd(e);
            }
        }
        if (INSTANCE == null) {
            INSTANCE = new SharedPreferenceCookieManager();
        }
        return INSTANCE;
    }

    public SharedPreferenceCookieManager(Map<String, List<Cookie>> cookieJar) {
        this.cookieJar = cookieJar;
    }

    private SharedPreferenceCookieManager() {
        this.cookieJar = new HashMap<String, List<Cookie>>();
    }

    public Map<String, List<Cookie>> getCookieJar() {
        return this.cookieJar;
    }

    private void persistCookies() {
        AppAdapter.get().setCookies(this);
    }

    public synchronized void clearAllCookies() {
        this.cookieJar.clear();
        this.persistCookies();
    }

    @Nullable
    public synchronized String getCookieByName(@NonNull String name) {
        for (String domainSpec : this.cookieJar.keySet()) {
            for (Cookie cookie : this.cookieJar.get(domainSpec)) {
                if (!cookie.name().equals(name)) continue;
                return cookie.value();
            }
        }
        return null;
    }

    public synchronized void saveFromResponse(@NonNull HttpUrl url, @NonNull List<Cookie> cookies) {
        if (cookies.isEmpty()) {
            return;
        }
        boolean cookieJarModified = false;
        for (Cookie cookie : cookies) {
            Iterator<Cookie> i;
            String domainSpec;
            String string = domainSpec = TextUtils.isEmpty((CharSequence)cookie.domain()) ? url.uri().getAuthority() : cookie.domain();
            if (!this.cookieJar.containsKey(domainSpec)) {
                this.cookieJar.put(domainSpec, new ArrayList());
            }
            List<Cookie> cookieList = this.cookieJar.get(domainSpec);
            if (cookie.expiresAt() < System.currentTimeMillis() || "deleted".equals(cookie.value())) {
                i = cookieList.iterator();
                while (i.hasNext()) {
                    if (!i.next().name().equals(cookie.name())) continue;
                    i.remove();
                    cookieJarModified = true;
                }
                continue;
            }
            i = cookieList.iterator();
            boolean exists = false;
            while (i.hasNext()) {
                Cookie c = i.next();
                if (c.equals((Object)cookie)) {
                    exists = true;
                    break;
                }
                if (!c.name().equals(cookie.name())) continue;
                i.remove();
            }
            if (exists) continue;
            cookieList.add(cookie);
            cookieJarModified = true;
        }
        if (cookieJarModified) {
            this.persistCookies();
        }
    }

    public synchronized List<Cookie> loadForRequest(@NonNull HttpUrl url) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        String domain = url.uri().getAuthority();
        for (String domainSpec : this.cookieJar.keySet()) {
            List<Cookie> cookiesForDomainSpec = this.cookieJar.get(domainSpec);
            if (domain.endsWith(domainSpec)) {
                this.buildCookieList(cookieList, cookiesForDomainSpec, null);
                continue;
            }
            if (!domainSpec.endsWith("wikipedia.org")) continue;
            this.buildCookieList(cookieList, cookiesForDomainSpec, CENTRALAUTH_PREFIX);
        }
        return cookieList;
    }

    private void buildCookieList(@NonNull List<Cookie> outList, @NonNull List<Cookie> inList, @Nullable String prefix) {
        Iterator<Cookie> i = inList.iterator();
        boolean cookieJarModified = false;
        while (i.hasNext()) {
            Cookie cookie = i.next();
            if (prefix != null && !cookie.name().startsWith(prefix)) continue;
            if (cookie.expiresAt() < System.currentTimeMillis()) {
                i.remove();
                cookieJarModified = true;
                continue;
            }
            outList.add(cookie);
        }
        if (cookieJarModified) {
            this.persistCookies();
        }
    }
}

