/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.search;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.search.SearchResult;

public class SearchResults {
    @NonNull
    private List<SearchResult> results;
    @Nullable
    private Map<String, String> continuation;
    @Nullable
    private String suggestion;

    public SearchResults() {
        this.results = new ArrayList<SearchResult>();
        this.continuation = null;
    }

    public SearchResults(@NonNull List<MwQueryPage> pages, @NonNull WikiSite wiki, @Nullable Map<String, String> continuation, @Nullable String suggestion) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        Collections.sort(pages, (a, b) -> Integer.valueOf(a.index()).compareTo(b.index()));
        for (MwQueryPage page : pages) {
            searchResults.add(new SearchResult(page, wiki));
        }
        this.results = searchResults;
        this.continuation = continuation;
        this.suggestion = suggestion;
    }

    @NonNull
    public List<SearchResult> getResults() {
        return this.results;
    }

    @Nullable
    public String getSuggestion() {
        return this.suggestion;
    }

    @Nullable
    public Map<String, String> getContinuation() {
        return this.continuation;
    }
}

