/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.edit;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.io.IOException;
import org.wikipedia.captcha.CaptchaResult;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.edit.Edit;
import org.wikipedia.edit.EditAbuseFilterResult;
import org.wikipedia.edit.EditResult;
import org.wikipedia.edit.EditSpamBlacklistResult;
import org.wikipedia.edit.EditSuccessResult;
import org.wikipedia.page.PageTitle;
import retrofit2.Call;
import retrofit2.Response;

public class EditClient {
    public Call<Edit> request(@NonNull WikiSite wiki, @NonNull PageTitle title, int section, @NonNull String text, @NonNull String token, @NonNull String summary, @Nullable String baseTimeStamp, boolean loggedIn, @Nullable String captchaId, @Nullable String captchaWord, @NonNull Callback cb) {
        return this.request(ServiceFactory.get(wiki), title, section, text, token, summary, baseTimeStamp, loggedIn, captchaId, captchaWord, cb);
    }

    @VisibleForTesting
    Call<Edit> request(@NonNull Service service, @NonNull PageTitle title, int section, @NonNull String text, @NonNull String token, @NonNull String summary, @Nullable String baseTimeStamp, boolean loggedIn, @Nullable String captchaId, @Nullable String captchaWord, final @NonNull Callback cb) {
        Call<Edit> call = service.postEditSubmit(title.getPrefixedText(), section, summary, loggedIn ? "user" : null, text, baseTimeStamp, token, captchaId, captchaWord);
        call.enqueue((retrofit2.Callback)new retrofit2.Callback<Edit>(){

            public void onResponse(@NonNull Call<Edit> call, @NonNull Response<Edit> response) {
                if (((Edit)response.body()).hasEditResult()) {
                    EditClient.this.handleEditResult(((Edit)response.body()).edit(), (Call<Edit>)call, cb);
                } else {
                    cb.failure(call, new IOException("An unknown error occurred."));
                }
            }

            public void onFailure(@NonNull Call<Edit> call, @NonNull Throwable t) {
                cb.failure(call, t);
            }
        });
        return call;
    }

    private void handleEditResult(@NonNull Edit.Result result, @NonNull Call<Edit> call, @NonNull Callback cb) {
        if (result.editSucceeded()) {
            cb.success(call, new EditSuccessResult(result.newRevId()));
        } else if (result.hasEditErrorCode()) {
            cb.success(call, new EditAbuseFilterResult(result.code(), result.info(), result.warning()));
        } else if (result.hasSpamBlacklistResponse()) {
            cb.success(call, new EditSpamBlacklistResult(result.spamblacklist()));
        } else if (result.hasCaptchaResponse()) {
            cb.success(call, new CaptchaResult(result.captchaId()));
        } else {
            cb.failure(call, new IOException("Received unrecognized edit response"));
        }
    }

    public static interface Callback {
        public void success(@NonNull Call<Edit> var1, @NonNull EditResult var2);

        public void failure(@NonNull Call<Edit> var1, @NonNull Throwable var2);
    }
}

