/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.gallery.ImageInfo;
import org.wikipedia.gallery.VideoInfo;
import org.wikipedia.model.BaseModel;
import org.wikipedia.page.Namespace;

public class MwQueryPage
extends BaseModel {
    private int pageid;
    private int ns;
    private int index;
    @NonNull
    private String title;
    @Nullable
    private List<LangLink> langlinks;
    @Nullable
    private List<Revision> revisions;
    @Nullable
    private List<Coordinates> coordinates;
    @Nullable
    private List<Category> categories;
    @Nullable
    private PageProps pageprops;
    @Nullable
    private String extract;
    @Nullable
    private Thumbnail thumbnail;
    @Nullable
    private String description;
    @SerializedName(value="descriptionsource")
    @Nullable
    private String descriptionSource;
    @SerializedName(value="imageinfo")
    @Nullable
    private List<ImageInfo> imageInfo;
    @SerializedName(value="videoinfo")
    @Nullable
    private List<VideoInfo> videoInfo;
    @Nullable
    private String redirectFrom;
    @Nullable
    private String convertedFrom;
    @Nullable
    private String convertedTo;

    @NonNull
    public String title() {
        return this.title;
    }

    public int index() {
        return this.index;
    }

    @NonNull
    public Namespace namespace() {
        return Namespace.of(this.ns);
    }

    @Nullable
    public List<LangLink> langLinks() {
        return this.langlinks;
    }

    @Nullable
    public List<Revision> revisions() {
        return this.revisions;
    }

    @Nullable
    public List<Category> categories() {
        return this.categories;
    }

    @Nullable
    public List<Coordinates> coordinates() {
        if (this.coordinates != null) {
            this.coordinates.removeAll(Collections.singleton(null));
        }
        return this.coordinates;
    }

    public int pageId() {
        return this.pageid;
    }

    @Nullable
    public PageProps pageProps() {
        return this.pageprops;
    }

    @Nullable
    public String extract() {
        return this.extract;
    }

    @Nullable
    public String thumbUrl() {
        return this.thumbnail != null ? this.thumbnail.source() : null;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String descriptionSource() {
        return this.descriptionSource;
    }

    @Nullable
    public ImageInfo imageInfo() {
        return this.imageInfo != null ? this.imageInfo.get(0) : null;
    }

    @Nullable
    public VideoInfo videoInfo() {
        return this.videoInfo != null ? this.videoInfo.get(0) : null;
    }

    @Nullable
    public String redirectFrom() {
        return this.redirectFrom;
    }

    public void redirectFrom(@Nullable String from) {
        this.redirectFrom = from;
    }

    @Nullable
    public String convertedFrom() {
        return this.convertedFrom;
    }

    public void convertedFrom(@Nullable String from) {
        this.convertedFrom = from;
    }

    @Nullable
    public String convertedTo() {
        return this.convertedTo;
    }

    public void convertedTo(@Nullable String to) {
        this.convertedTo = to;
    }

    public void appendTitleFragment(@Nullable String fragment) {
        this.title = this.title + "#" + fragment;
    }

    public static class Category {
        private int ns;
        @Nullable
        private String title;
        private boolean hidden;

        public int ns() {
            return this.ns;
        }

        @NonNull
        public String title() {
            return StringUtils.defaultString((String)this.title);
        }

        public boolean hidden() {
            return this.hidden;
        }
    }

    public static class PageProps {
        @SerializedName(value="wikibase_item")
        @Nullable
        private String wikiBaseItem;
        @Nullable
        private String displaytitle;
        @Nullable
        private String disambiguation;

        @Nullable
        public String getDisplayTitle() {
            return this.displaytitle;
        }

        @NonNull
        public String getWikiBaseItem() {
            return StringUtils.defaultString((String)this.wikiBaseItem);
        }

        public boolean isDisambiguation() {
            return this.disambiguation != null;
        }
    }

    static class Thumbnail {
        private String source;
        private int width;
        private int height;

        Thumbnail() {
        }

        String source() {
            return this.source;
        }
    }

    public static class Coordinates {
        @Nullable
        private Double lat;
        @Nullable
        private Double lon;

        @Nullable
        public Double lat() {
            return this.lat;
        }

        @Nullable
        public Double lon() {
            return this.lon;
        }
    }

    public static class LangLink {
        @NonNull
        private String lang;
        @NonNull
        private String title;

        @NonNull
        public String lang() {
            return this.lang;
        }

        @NonNull
        public String title() {
            return this.title;
        }
    }

    public static class Revision {
        @SerializedName(value="revid")
        private long revisionId;
        private String user;
        @SerializedName(value="contentformat")
        @NonNull
        private String contentFormat;
        @SerializedName(value="contentmodel")
        @NonNull
        private String contentModel;
        @SerializedName(value="timestamp")
        @NonNull
        private String timeStamp;
        @NonNull
        private String content;

        @NonNull
        public String content() {
            return this.content;
        }

        @NonNull
        public String timeStamp() {
            return StringUtils.defaultString((String)this.timeStamp);
        }

        public long getRevisionId() {
            return this.revisionId;
        }

        @NonNull
        public String getUser() {
            return StringUtils.defaultString((String)this.user);
        }
    }
}

