/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.csrf;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.io.IOException;
import org.wikipedia.AppAdapter;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.SharedPreferenceCookieManager;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.MwQueryResponse;
import org.wikipedia.login.LoginClient;
import org.wikipedia.login.LoginResult;
import org.wikipedia.util.log.L;
import retrofit2.Call;
import retrofit2.Response;

public class CsrfTokenClient {
    private static final String ANON_TOKEN = "+\\";
    private static final int MAX_RETRIES = 1;
    private static final int MAX_RETRIES_OF_LOGIN_BLOCKING = 2;
    @NonNull
    private final WikiSite csrfWikiSite;
    @NonNull
    private final WikiSite loginWikiSite;
    private int retries = 0;
    @Nullable
    private Call<MwQueryResponse> csrfTokenCall;
    @NonNull
    private LoginClient loginClient = new LoginClient();

    public CsrfTokenClient(@NonNull WikiSite csrfWikiSite, @NonNull WikiSite loginWikiSite) {
        this.csrfWikiSite = csrfWikiSite;
        this.loginWikiSite = loginWikiSite;
    }

    public void request(@NonNull Callback callback) {
        this.request(false, callback);
    }

    public void request(boolean forceLogin, @NonNull Callback callback) {
        this.cancel();
        if (forceLogin) {
            this.retryWithLogin(new RuntimeException("Forcing login..."), callback);
            return;
        }
        this.csrfTokenCall = this.request(ServiceFactory.get(this.csrfWikiSite), callback);
    }

    public void cancel() {
        this.loginClient.cancel();
        if (this.csrfTokenCall != null) {
            this.csrfTokenCall.cancel();
            this.csrfTokenCall = null;
        }
    }

    @VisibleForTesting
    @NonNull
    Call<MwQueryResponse> request(@NonNull Service service, final @NonNull Callback cb) {
        return this.requestToken(service, new Callback(){

            @Override
            public void success(@NonNull String token) {
                if (AppAdapter.get().isLoggedIn() && token.equals(CsrfTokenClient.ANON_TOKEN)) {
                    CsrfTokenClient.this.retryWithLogin(new RuntimeException("App believes we're logged in, but got anonymous token."), cb);
                } else {
                    cb.success(token);
                }
            }

            @Override
            public void failure(@NonNull Throwable caught) {
                CsrfTokenClient.this.retryWithLogin(caught, cb);
            }

            @Override
            public void twoFactorPrompt() {
                cb.twoFactorPrompt();
            }
        });
    }

    private void retryWithLogin(@NonNull Throwable caught, @NonNull Callback callback) {
        if (this.retries < 1 && !TextUtils.isEmpty((CharSequence)AppAdapter.get().getUserName()) && !TextUtils.isEmpty((CharSequence)AppAdapter.get().getPassword())) {
            ++this.retries;
            SharedPreferenceCookieManager.getInstance().clearAllCookies();
            this.login(AppAdapter.get().getUserName(), AppAdapter.get().getPassword(), () -> {
                L.i("retrying...");
                this.request(callback);
            }, callback);
        } else {
            callback.failure(caught);
        }
    }

    private void login(@NonNull String username, @NonNull String password, final @NonNull RetryCallback retryCallback, final @NonNull Callback callback) {
        new LoginClient().request(this.loginWikiSite, username, password, new LoginClient.LoginCallback(){

            @Override
            public void success(@NonNull LoginResult loginResult) {
                if (loginResult.pass()) {
                    AppAdapter.get().updateAccount(loginResult);
                    retryCallback.retry();
                } else {
                    callback.failure(new LoginClient.LoginFailedException(loginResult.getMessage()));
                }
            }

            @Override
            public void twoFactorPrompt(@NonNull Throwable caught, @Nullable String token) {
                callback.twoFactorPrompt();
            }

            @Override
            public void passwordResetPrompt(@Nullable String token) {
                callback.failure(new LoginClient.LoginFailedException("Logged in with temporary password."));
            }

            @Override
            public void error(@NonNull Throwable caught) {
                callback.failure(caught);
            }
        });
    }

    @NonNull
    public String getTokenBlocking() throws Throwable {
        String token = "";
        Service service = ServiceFactory.get(this.csrfWikiSite);
        for (int retry = 0; retry < 2; ++retry) {
            try {
                Response response;
                if (retry > 0) {
                    new LoginClient().loginBlocking(this.loginWikiSite, AppAdapter.get().getUserName(), AppAdapter.get().getPassword(), "");
                }
                if ((response = service.getCsrfToken().execute()).body() == null || ((MwQueryResponse)response.body()).query() == null || TextUtils.isEmpty((CharSequence)((MwQueryResponse)response.body()).query().csrfToken())) continue;
                token = ((MwQueryResponse)response.body()).query().csrfToken();
                if (!AppAdapter.get().isLoggedIn() || !token.equals(ANON_TOKEN)) break;
                throw new RuntimeException("App believes we're logged in, but got anonymous token.");
            }
            catch (Throwable t) {
                L.w(t);
            }
        }
        if (TextUtils.isEmpty((CharSequence)token) || token.equals(ANON_TOKEN)) {
            throw new IOException("Invalid token, or login failure.");
        }
        return token;
    }

    @VisibleForTesting
    @NonNull
    Call<MwQueryResponse> requestToken(@NonNull Service service, final @NonNull Callback cb) {
        Call<MwQueryResponse> call = service.getCsrfToken();
        call.enqueue((retrofit2.Callback)new retrofit2.Callback<MwQueryResponse>(){

            public void onResponse(@NonNull Call<MwQueryResponse> call, @NonNull Response<MwQueryResponse> response) {
                if (call.isCanceled()) {
                    return;
                }
                cb.success(((MwQueryResponse)response.body()).query().csrfToken());
            }

            public void onFailure(@NonNull Call<MwQueryResponse> call, @NonNull Throwable t) {
                if (call.isCanceled()) {
                    return;
                }
                cb.failure(t);
            }
        });
        return call;
    }

    private static interface RetryCallback {
        public void retry();
    }

    public static class DefaultCallback
    implements Callback {
        @Override
        public void success(@NonNull String token) {
        }

        @Override
        public void failure(@NonNull Throwable caught) {
            L.e(caught);
        }

        @Override
        public void twoFactorPrompt() {
        }
    }

    public static interface Callback {
        public void success(@NonNull String var1);

        public void failure(@NonNull Throwable var1);

        public void twoFactorPrompt();
    }
}

