/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.view.View;

public final class ViewAnimations {
    private static long SHORT_ANIMATION_DURATION;
    private static long MEDIUM_ANIMATION_DURATION;

    private ViewAnimations() {
    }

    public static void init(Resources resources) {
        SHORT_ANIMATION_DURATION = resources.getInteger(0x10E0000);
        MEDIUM_ANIMATION_DURATION = resources.getInteger(0x10E0001);
    }

    public static void crossFade(View curView, View newView) {
        ViewAnimations.fadeIn(newView);
        ViewAnimations.fadeOut(curView);
    }

    public static void crossFade(View curView, View newView, Runnable runOnComplete) {
        ViewAnimations.fadeIn(newView);
        ViewAnimations.fadeOut(curView, runOnComplete);
    }

    public static void fadeIn(View view) {
        ViewAnimations.fadeIn(view, null);
    }

    public static void fadeIn(View view, final @Nullable Runnable runOnComplete) {
        view.setAlpha(0.0f);
        view.setVisibility(0);
        view.animate().alpha(1.0f).setDuration(MEDIUM_ANIMATION_DURATION).setListener((Animator.AnimatorListener)new CancelStateAnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!this.canceled() && runOnComplete != null) {
                    runOnComplete.run();
                }
            }
        }).start();
    }

    public static void fadeOut(View view) {
        ViewAnimations.fadeOut(view, null);
    }

    public static void fadeOut(final View view, final Runnable runOnComplete) {
        view.animate().cancel();
        view.animate().alpha(0.0f).setDuration(MEDIUM_ANIMATION_DURATION).setListener((Animator.AnimatorListener)new CancelStateAnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!this.canceled()) {
                    view.setVisibility(8);
                    view.setAlpha(1.0f);
                    if (runOnComplete != null) {
                        runOnComplete.run();
                    }
                }
            }
        }).start();
    }

    public static void ensureTranslationY(View view, int translation) {
        if (view.getTranslationY() != (float)translation) {
            view.animate().translationY((float)translation).setDuration(SHORT_ANIMATION_DURATION).start();
        }
    }

    private static class CancelStateAnimatorListenerAdapter
    extends AnimatorListenerAdapter {
        private boolean canceled;

        private CancelStateAnimatorListenerAdapter() {
        }

        public void onAnimationCancel(Animator animation) {
            this.canceled = true;
        }

        protected boolean canceled() {
            return this.canceled;
        }
    }
}

