/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import org.wikipedia.dataclient.SharedPreferenceCookieManager;

public class CookieManagerTypeAdapter
extends TypeAdapter<SharedPreferenceCookieManager> {
    public void write(JsonWriter out, SharedPreferenceCookieManager cookies) throws IOException {
        Map<String, List<Cookie>> map = cookies.getCookieJar();
        out.beginObject();
        for (String key : map.keySet()) {
            out.name(key).beginArray();
            for (Cookie cookie : map.get(key)) {
                out.value(cookie.toString());
            }
            out.endArray();
        }
        out.endObject();
    }

    public SharedPreferenceCookieManager read(JsonReader in) throws IOException {
        HashMap<String, List<Cookie>> map = new HashMap<String, List<Cookie>>();
        in.beginObject();
        while (in.hasNext()) {
            String key = in.nextName();
            ArrayList<Cookie> list = new ArrayList<Cookie>();
            map.put(key, list);
            in.beginArray();
            HttpUrl url = HttpUrl.parse((String)("https://" + key));
            while (in.hasNext()) {
                String str = in.nextString();
                if (url == null) continue;
                list.add(Cookie.parse((HttpUrl)url, (String)str));
            }
            in.endArray();
        }
        in.endObject();
        return new SharedPreferenceCookieManager(map);
    }
}

