/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.feed.configure;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import org.wikipedia.dataclient.RestService;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import retrofit2.Call;
import retrofit2.Response;

public class FeedAvailabilityClient {
    private final WikiSite wiki = new WikiSite("wikimedia.org");

    public Call<FeedAvailability> request(@NonNull Callback cb) {
        return this.request(ServiceFactory.getRest(this.wiki), cb);
    }

    @VisibleForTesting
    Call<FeedAvailability> request(@NonNull RestService service, final @NonNull Callback cb) {
        Call<FeedAvailability> call = service.getFeedAvailability();
        call.enqueue((retrofit2.Callback)new retrofit2.Callback<FeedAvailability>(){

            public void onResponse(@NonNull Call<FeedAvailability> call, @NonNull Response<FeedAvailability> response) {
                if (response.body() != null) {
                    cb.success(call, (FeedAvailability)response.body());
                } else {
                    cb.failure(call, new RuntimeException("Incorrect response format"));
                }
            }

            public void onFailure(@NonNull Call<FeedAvailability> call, @NonNull Throwable t) {
                cb.failure(call, t);
            }
        });
        return call;
    }

    public class FeedAvailability {
        @SerializedName(value="todays_featured_article")
        private List<String> featuredArticle;
        @SerializedName(value="most_read")
        private List<String> mostRead;
        @SerializedName(value="picture_of_the_day")
        private List<String> featuredPicture;
        @SerializedName(value="in_the_news")
        private List<String> news;
        @SerializedName(value="on_this_day")
        private List<String> onThisDay;

        @NonNull
        public List<String> featuredArticle() {
            return this.featuredArticle != null ? this.featuredArticle : Collections.emptyList();
        }

        @NonNull
        public List<String> mostRead() {
            return this.mostRead != null ? this.mostRead : Collections.emptyList();
        }

        @NonNull
        public List<String> featuredPicture() {
            return this.featuredPicture != null ? this.featuredPicture : Collections.emptyList();
        }

        @NonNull
        public List<String> news() {
            return this.news != null ? this.news : Collections.emptyList();
        }

        @NonNull
        public List<String> onThisDay() {
            return this.onThisDay != null ? this.onThisDay : Collections.emptyList();
        }
    }

    public static interface Callback {
        public void success(@NonNull Call<FeedAvailability> var1, @NonNull FeedAvailability var2);

        public void failure(@NonNull Call<FeedAvailability> var1, @NonNull Throwable var2);
    }
}

