/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.edit.wikitext;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.gson.JsonParseException;
import org.wikipedia.dataclient.Service;
import org.wikipedia.dataclient.ServiceFactory;
import org.wikipedia.dataclient.WikiSite;
import org.wikipedia.dataclient.mwapi.MwQueryPage;
import org.wikipedia.dataclient.mwapi.MwQueryResponse;
import org.wikipedia.dataclient.mwapi.MwQueryResult;
import org.wikipedia.page.PageTitle;
import retrofit2.Call;
import retrofit2.Response;

public class WikitextClient {
    public Call<MwQueryResponse> request(@NonNull WikiSite wiki, @NonNull PageTitle title, int sectionID, @NonNull Callback cb) {
        return this.request(ServiceFactory.get(wiki), title, sectionID, cb);
    }

    @VisibleForTesting
    Call<MwQueryResponse> request(@NonNull Service service, @NonNull PageTitle title, int sectionID, final @NonNull Callback cb) {
        Call<MwQueryResponse> call = service.getWikiTextForSection(title.getPrefixedText(), sectionID);
        call.enqueue((retrofit2.Callback)new retrofit2.Callback<MwQueryResponse>(){

            public void onResponse(@NonNull Call<MwQueryResponse> call, @NonNull Response<MwQueryResponse> response) {
                if (response.body() != null && ((MwQueryResponse)response.body()).query() != null && ((MwQueryResponse)response.body()).query().firstPage() != null && WikitextClient.this.getRevision(((MwQueryResponse)response.body()).query()) != null) {
                    MwQueryPage.Revision rev = WikitextClient.this.getRevision(((MwQueryResponse)response.body()).query());
                    cb.success(call, ((MwQueryResponse)response.body()).query().firstPage().title(), rev.content(), rev.timeStamp());
                } else {
                    JsonParseException t = new JsonParseException("Error parsing wikitext from query response");
                    cb.failure(call, (Throwable)t);
                }
            }

            public void onFailure(@NonNull Call<MwQueryResponse> call, @NonNull Throwable t) {
                cb.failure(call, t);
            }
        });
        return call;
    }

    @Nullable
    private MwQueryPage.Revision getRevision(@Nullable MwQueryResult result) {
        MwQueryPage page;
        if (result != null && result.pages() != null && result.pages().size() > 0 && (page = result.pages().get(0)).revisions() != null && page.revisions().size() > 0) {
            return page.revisions().get(0);
        }
        return null;
    }

    public static interface Callback {
        public void success(@NonNull Call<MwQueryResponse> var1, @NonNull String var2, @NonNull String var3, @Nullable String var4);

        public void failure(@NonNull Call<MwQueryResponse> var1, @NonNull Throwable var2);
    }
}

