/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient.mwapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wikipedia.dataclient.ServiceError;
import org.wikipedia.model.BaseModel;

public class MwServiceError
extends BaseModel
implements ServiceError {
    @Nullable
    private String code;
    @Nullable
    private String text;
    @Nullable
    private Data data;

    @Override
    @NonNull
    public String getTitle() {
        return StringUtils.defaultString((String)this.code);
    }

    @Override
    @NonNull
    public String getDetails() {
        return StringUtils.defaultString((String)this.text);
    }

    public boolean badToken() {
        return "badtoken".equals(this.code);
    }

    public boolean badLoginState() {
        return "assertuserfailed".equals(this.code);
    }

    public boolean hasMessageName(@NonNull String messageName) {
        if (this.data != null && this.data.messages() != null) {
            for (Message msg : this.data.messages()) {
                if (!messageName.equals(msg.name)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public String getMessageHtml(@NonNull String messageName) {
        if (this.data != null && this.data.messages() != null) {
            for (Message msg : this.data.messages()) {
                if (!messageName.equals(msg.name)) continue;
                return msg.html();
            }
        }
        return null;
    }

    private static final class Message {
        @Nullable
        private String name;
        @Nullable
        private String html;

        private Message() {
        }

        @NonNull
        private String html() {
            return StringUtils.defaultString((String)this.html);
        }
    }

    private static final class Data {
        @Nullable
        private List<Message> messages;

        private Data() {
        }

        @Nullable
        private List<Message> messages() {
            return this.messages;
        }
    }
}

