/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.dataclient;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.reactivex.Observable;
import java.util.Map;
import org.wikipedia.dataclient.restbase.RbDefinition;
import org.wikipedia.dataclient.restbase.RbRelatedPages;
import org.wikipedia.dataclient.restbase.page.RbPageLead;
import org.wikipedia.dataclient.restbase.page.RbPageRemaining;
import org.wikipedia.dataclient.restbase.page.RbPageSummary;
import org.wikipedia.feed.aggregated.AggregatedFeedContent;
import org.wikipedia.feed.announcement.AnnouncementList;
import org.wikipedia.feed.configure.FeedAvailabilityClient;
import org.wikipedia.feed.onthisday.OnThisDay;
import org.wikipedia.gallery.Gallery;
import org.wikipedia.readinglist.sync.SyncedReadingLists;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface RestService {
    public static final String REST_API_PREFIX = "api/rest_v1/";
    public static final String ACCEPT_HEADER_PREFIX = "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/";
    public static final String ACCEPT_HEADER_SUMMARY = "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/Summary/1.2.0\"";
    public static final String ACCEPT_HEADER_MOBILE_SECTIONS = "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/mobile-sections/0.12.4\"";
    public static final String ACCEPT_HEADER_DEFINITION = "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/definition/0.7.2\"";
    public static final String REST_PAGE_SECTIONS_URL = "page/mobile-sections-remaining/{title}";

    @Headers(value={"x-analytics: preview=1", "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/Summary/1.2.0\""})
    @GET(value="page/summary/{title}")
    @NonNull
    public Observable<RbPageSummary> getSummary(@Header(value="Referer") @Nullable String var1, @Path(value="title") @NonNull String var2);

    @Headers(value={"x-analytics: pageview=1", "accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/mobile-sections/0.12.4\""})
    @GET(value="page/mobile-sections-lead/{title}")
    @NonNull
    public Observable<Response<RbPageLead>> getLeadSection(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Header(value="Referer") @Nullable String var3, @Path(value="title") @NonNull String var4);

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/mobile-sections/0.12.4\""})
    @GET(value="page/mobile-sections-remaining/{title}")
    @NonNull
    public Observable<Response<RbPageRemaining>> getRemainingSections(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Path(value="title") @NonNull String var3);

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/mobile-sections/0.12.4\""})
    @GET(value="page/mobile-sections-remaining/{title}")
    @NonNull
    public Call<RbPageRemaining> getRemainingSectionsUrl(@Header(value="Cache-Control") @Nullable String var1, @Header(value="X-Offline-Save") @Nullable String var2, @Path(value="title") @NonNull String var3);

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/definition/0.7.2\""})
    @GET(value="page/definition/{title}")
    @NonNull
    public Observable<Map<String, RbDefinition.Usage[]>> getDefinition(@Path(value="title") @NonNull String var1);

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/Summary/1.2.0\""})
    @GET(value="page/random/summary")
    @NonNull
    public Observable<RbPageSummary> getRandomSummary();

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/Summary/1.2.0\""})
    @GET(value="page/related/{title}")
    @NonNull
    public Observable<RbRelatedPages> getRelatedPages(@Path(value="title") String var1);

    @GET(value="page/media/{title}")
    @NonNull
    public Observable<Gallery> getMedia(@Path(value="title") String var1);

    @GET(value="feed/onthisday/events/{mm}/{dd}")
    @NonNull
    public Call<OnThisDay> getOnThisDay(@Path(value="mm") int var1, @Path(value="dd") int var2);

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/announcements/0.1.0\""})
    @GET(value="feed/announcements")
    @NonNull
    public Call<AnnouncementList> getAnnouncements();

    @Headers(value={"accept: application/json; charset=utf-8; profile=\"https://www.mediawiki.org/wiki/Specs/aggregated-feed/0.5.0\""})
    @GET(value="feed/featured/{year}/{month}/{day}")
    @NonNull
    public Observable<AggregatedFeedContent> getAggregatedFeed(@Path(value="year") String var1, @Path(value="month") String var2, @Path(value="day") String var3);

    @GET(value="feed/availability")
    @NonNull
    public Call<FeedAvailabilityClient.FeedAvailability> getFeedAvailability();

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="data/lists/setup")
    @NonNull
    public Call<Void> setupReadingLists(@Query(value="csrf_token") String var1);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="data/lists/teardown")
    @NonNull
    public Call<Void> tearDownReadingLists(@Query(value="csrf_token") String var1);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="data/lists/")
    @NonNull
    public Call<SyncedReadingLists> getReadingLists(@Query(value="next") String var1);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="data/lists/")
    @NonNull
    public Call<SyncedReadingLists.RemoteIdResponse> createReadingList(@Query(value="csrf_token") String var1, @Body SyncedReadingLists.RemoteReadingList var2);

    @Headers(value={"Cache-Control: no-cache"})
    @PUT(value="data/lists/{id}")
    @NonNull
    public Call<Void> updateReadingList(@Path(value="id") long var1, @Query(value="csrf_token") String var3, @Body SyncedReadingLists.RemoteReadingList var4);

    @Headers(value={"Cache-Control: no-cache"})
    @DELETE(value="data/lists/{id}")
    @NonNull
    public Call<Void> deleteReadingList(@Path(value="id") long var1, @Query(value="csrf_token") String var3);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="data/lists/changes/since/{date}")
    @NonNull
    public Call<SyncedReadingLists> getReadingListChangesSince(@Path(value="date") String var1, @Query(value="next") String var2);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="data/lists/pages/{project}/{title}")
    @NonNull
    public Call<SyncedReadingLists> getReadingListsContaining(@Path(value="project") String var1, @Path(value="title") String var2, @Query(value="next") String var3);

    @Headers(value={"Cache-Control: no-cache"})
    @GET(value="data/lists/{id}/entries/")
    @NonNull
    public Call<SyncedReadingLists> getReadingListEntries(@Path(value="id") long var1, @Query(value="next") String var3);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="data/lists/{id}/entries/")
    @NonNull
    public Call<SyncedReadingLists.RemoteIdResponse> addEntryToReadingList(@Path(value="id") long var1, @Query(value="csrf_token") String var3, @Body SyncedReadingLists.RemoteReadingListEntry var4);

    @Headers(value={"Cache-Control: no-cache"})
    @POST(value="data/lists/{id}/entries/batch")
    @NonNull
    public Call<SyncedReadingLists.RemoteIdResponseBatch> addEntriesToReadingList(@Path(value="id") long var1, @Query(value="csrf_token") String var3, @Body SyncedReadingLists.RemoteReadingListEntryBatch var4);

    @Headers(value={"Cache-Control: no-cache"})
    @DELETE(value="data/lists/{id}/entries/{entry_id}")
    @NonNull
    public Call<Void> deleteEntryFromReadingList(@Path(value="id") long var1, @Path(value="entry_id") long var3, @Query(value="csrf_token") String var5);
}

