/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/ditchoom/buffer/AndroidBufferHelper;", "", "<init>", "()V", "addressField", "Ljava/lang/reflect/Field;", "getAddressField", "()Ljava/lang/reflect/Field;", "addressField$delegate", "Lkotlin/Lazy;", "getDirectBufferAddress", "", "buffer", "Ljava/nio/ByteBuffer;", "buffer_release"})
public final class AndroidBufferHelper {
    @NotNull
    public static final AndroidBufferHelper INSTANCE = new AndroidBufferHelper();
    @NotNull
    private static final Lazy addressField$delegate = LazyKt.lazy(AndroidBufferHelper::addressField_delegate$lambda$0);

    private AndroidBufferHelper() {
    }

    private final Field getAddressField() {
        Lazy lazy = addressField$delegate;
        return (Field)lazy.getValue();
    }

    public final long getDirectBufferAddress(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Field field = this.getAddressField();
        if (field == null) {
            throw new UnsupportedOperationException("Cannot access native address on this Android version.");
        }
        return field.getLong(buffer);
    }

    private static final Field addressField_delegate$lambda$0() {
        Field field;
        try {
            Field $this$addressField_delegate_u24lambda_u240_u240 = field = Buffer.class.getDeclaredField("address");
            boolean bl = false;
            $this$addressField_delegate_u24lambda_u240_u240.setAccessible(true);
        }
        catch (Exception e) {
            field = null;
        }
        return field;
    }
}

