/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.BaseJvmBufferKt;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.CharsetEncoderHelperKt;
import com.ditchoom.buffer.JvmBuffer;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.ReadBuffer;
import com.ditchoom.buffer.WriteBuffer;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0011\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0017H\u0096\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001cH\u0016J\u0019\u00104\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u001cH\u0096\u0002J \u00105\u001a\u0002022\u0006\u00106\u001a\u00020 2\u0006\u00107\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0016J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020%H\u0016J\u0019\u00104\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u00109\u001a\u00020%H\u0096\u0002J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u0017H\u0016J\u0019\u00104\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u0017H\u0096\u0002J\u0010\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020*H\u0016J\u0019\u00104\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010=\u001a\u00020*H\u0096\u0002J\u0018\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010A\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u0017H\u0016J\u0014\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010HH\u0096\u0082\u0004J\n\u0010I\u001a\u00020-H\u0096\u0080\u0004J\u000e\u0010J\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010KJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010C\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006L"}, d2={"Lcom/ditchoom/buffer/BaseJvmBuffer;", "Lcom/ditchoom/buffer/PlatformBuffer;", "byteBuffer", "Ljava/nio/ByteBuffer;", "fileRef", "Ljava/io/RandomAccessFile;", "<init>", "(Ljava/nio/ByteBuffer;Ljava/io/RandomAccessFile;)V", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "getFileRef", "()Ljava/io/RandomAccessFile;", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "getByteOrder", "()Lcom/ditchoom/buffer/ByteOrder;", "buffer", "Ljava/nio/Buffer;", "resetForRead", "", "resetForWrite", "setLimit", "limit", "", "capacity", "getCapacity", "()I", "readByte", "", "get", "index", "readByteArray", "", "size", "slice", "Lcom/ditchoom/buffer/JvmBuffer;", "readShort", "", "getShort", "readInt", "getInt", "readLong", "", "getLong", "readString", "", "length", "charset", "Lcom/ditchoom/buffer/Charset;", "writeByte", "Lcom/ditchoom/buffer/WriteBuffer;", "byte", "set", "writeBytes", "bytes", "offset", "writeShort", "short", "writeInt", "int", "writeLong", "long", "writeString", "text", "", "write", "Lcom/ditchoom/buffer/ReadBuffer;", "position", "newPosition", "equals", "", "other", "", "toString", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buffer_release"})
public abstract class BaseJvmBuffer
implements PlatformBuffer {
    @NotNull
    private final ByteBuffer byteBuffer;
    @Nullable
    private final RandomAccessFile fileRef;
    @NotNull
    private final ByteOrder byteOrder;
    @NotNull
    private final Buffer buffer;
    private final int capacity;

    public BaseJvmBuffer(@NotNull ByteBuffer byteBuffer, @Nullable RandomAccessFile fileRef) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        this.byteBuffer = byteBuffer;
        this.fileRef = fileRef;
        java.nio.ByteOrder byteOrder = this.getByteBuffer().order();
        this.byteOrder = Intrinsics.areEqual((Object)byteOrder, (Object)java.nio.ByteOrder.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : (Intrinsics.areEqual((Object)byteOrder, (Object)java.nio.ByteOrder.LITTLE_ENDIAN) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        ByteBuffer byteBuffer2 = this.getByteBuffer();
        Intrinsics.checkNotNull((Object)byteBuffer2, (String)"null cannot be cast to non-null type java.nio.Buffer");
        this.buffer = byteBuffer2;
        this.capacity = this.buffer.capacity();
    }

    public /* synthetic */ BaseJvmBuffer(ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            randomAccessFile = null;
        }
        this(byteBuffer, randomAccessFile);
    }

    @NotNull
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Nullable
    public final RandomAccessFile getFileRef() {
        return this.fileRef;
    }

    @Override
    @NotNull
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public void resetForRead() {
        this.buffer.flip();
    }

    @Override
    public void resetForWrite() {
        this.buffer.clear();
    }

    @Override
    public void setLimit(int limit) {
        this.buffer.limit(limit);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public byte readByte() {
        return this.getByteBuffer().get();
    }

    @Override
    public byte get(int index) {
        return this.getByteBuffer().get(index);
    }

    @Override
    @NotNull
    public byte[] readByteArray(int size) {
        return BaseJvmBufferKt.toArray(this.getByteBuffer(), size);
    }

    @Override
    @NotNull
    public JvmBuffer slice() {
        ByteBuffer byteBuffer = this.getByteBuffer().slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return new JvmBuffer(byteBuffer);
    }

    @Override
    public short readShort() {
        return this.getByteBuffer().getShort();
    }

    @Override
    public short getShort(int index) {
        return this.getByteBuffer().getShort(index);
    }

    @Override
    public int readInt() {
        return this.getByteBuffer().getInt();
    }

    @Override
    public int getInt(int index) {
        return this.getByteBuffer().getInt(index);
    }

    @Override
    public long readLong() {
        return this.getByteBuffer().getLong();
    }

    @Override
    public long getLong(int index) {
        return this.getByteBuffer().getLong(index);
    }

    @Override
    @NotNull
    public String readString(int length, @NotNull Charset charset) {
        java.nio.charset.Charset charset2;
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        int finalPosition = this.buffer.position() + length;
        ByteBuffer readBuffer = this.getByteBuffer().asReadOnlyBuffer();
        Intrinsics.checkNotNull((Object)readBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)readBuffer).limit(finalPosition);
        switch (WhenMappings.$EnumSwitchMapping$0[charset.ordinal()]) {
            case 1: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16;
                break;
            }
            case 3: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 4: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 5: {
                charset2 = Charsets.US_ASCII;
                break;
            }
            case 6: {
                charset2 = Charsets.ISO_8859_1;
                break;
            }
            case 7: {
                charset2 = Charsets.INSTANCE.UTF32();
                break;
            }
            case 8: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case 9: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        java.nio.charset.Charset charsetConverted = charset2;
        CharBuffer decoded = charsetConverted.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(readBuffer);
        this.buffer.position(finalPosition);
        String string = decoded.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public WriteBuffer writeByte(byte by) {
        this.getByteBuffer().put(by);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, byte by) {
        this.getByteBuffer().put(index, by);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeBytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.getByteBuffer().put(bytes, offset, length);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeShort(short s) {
        this.getByteBuffer().putShort(s);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, short s) {
        this.getByteBuffer().putShort(index, s);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeInt(int n) {
        this.getByteBuffer().putInt(n);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, int n) {
        this.getByteBuffer().putInt(index, n);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeLong(long l) {
        this.getByteBuffer().putLong(l);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer set(int index, long l) {
        this.getByteBuffer().putLong(index, l);
        return this;
    }

    @Override
    @NotNull
    public WriteBuffer writeString(@NotNull CharSequence text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        CharsetEncoder encoder = CharsetEncoderHelperKt.toEncoder(charset);
        encoder.reset();
        encoder.encode(CharBuffer.wrap(text), this.getByteBuffer(), true);
        return this;
    }

    @Override
    public void write(@NotNull ReadBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = buffer instanceof JvmBuffer ? this.getByteBuffer().put(((JvmBuffer)buffer).getByteBuffer()) : this.getByteBuffer().put(buffer.readByteArray(buffer.remaining()));
    }

    @Override
    public void position(int newPosition) {
        this.buffer.position(newPosition);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PlatformBuffer)) {
            return false;
        }
        if (this.position() != ((PlatformBuffer)other).position()) {
            return false;
        }
        if (this.limit() != ((PlatformBuffer)other).limit()) {
            return false;
        }
        return this.getCapacity() == ((PlatformBuffer)other).getCapacity();
    }

    @NotNull
    public String toString() {
        return "Buffer[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.getCapacity() + ']';
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return BaseJvmBuffer.close$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object close$suspendImpl(BaseJvmBuffer $this, Continuation<? super Unit> $completion) {
        RandomAccessFile randomAccessFile = $this.fileRef;
        if (randomAccessFile != null) {
            Object object = BaseJvmBufferKt.aClose(randomAccessFile, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Charset.values().length];
            try {
                nArray[Charset.UTF8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16BigEndian.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF16LittleEndian.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ASCII.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.ISOLatin1.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32LittleEndian.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Charset.UTF32BigEndian.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

