/*
 * Decompiled with CFR 0.152.
 */
package com.diogonunes.jcdp.color;

import com.diogonunes.jcdp.color.api.AbstractColoredPrinter;
import com.diogonunes.jcdp.color.api.Ansi;
import com.diogonunes.jcdp.color.api.IColoredPrinter;
import com.diogonunes.jcdp.color.impl.UnixColoredPrinter;
import com.diogonunes.jcdp.color.impl.WindowsColoredPrinter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ColoredPrinter
implements IColoredPrinter {
    private AbstractColoredPrinter _impl;

    public ColoredPrinter(AbstractColoredPrinter implementation) {
        this.setImpl(implementation);
    }

    public ColoredPrinter(Builder b) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            this.setImpl(new WindowsColoredPrinter.Builder(b._level, b._timestampFlag).withFormat(b._dateFormat).attribute(b._attribute).foreground(b._foregroundColor).background(b._backgroundColor).build());
        } else {
            this.setImpl(new UnixColoredPrinter.Builder(b._level, b._timestampFlag).withFormat(b._dateFormat).attribute(b._attribute).foreground(b._foregroundColor).background(b._backgroundColor).build());
        }
    }

    private AbstractColoredPrinter getImpl() {
        return this._impl;
    }

    private void setImpl(AbstractColoredPrinter impl) {
        this._impl = impl;
    }

    @Override
    public int getLevel() {
        return this.getImpl().getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.getImpl().setLevel(level);
    }

    @Override
    public String getDateFormatted() {
        return this.getImpl().getDateFormatted();
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    @Override
    public void printTimestamp() {
        this.getImpl().printTimestamp();
    }

    @Override
    public void printErrorTimestamp() {
        this.getImpl().printTimestamp();
    }

    @Override
    public void print(Object msg) {
        this.getImpl().print(msg);
    }

    @Override
    public void println(Object msg) {
        this.getImpl().println(msg);
    }

    @Override
    public void errorPrint(Object msg) {
        this.getImpl().errorPrint(msg);
    }

    @Override
    public void errorPrintln(Object msg) {
        this.getImpl().errorPrintln(msg);
    }

    @Override
    public void debugPrint(Object msg) {
        this.getImpl().debugPrint(msg);
    }

    @Override
    public void debugPrint(Object msg, int level) {
        this.getImpl().debugPrint(msg, level);
    }

    @Override
    public void debugPrintln(Object msg) {
        this.getImpl().debugPrintln(msg);
    }

    @Override
    public void debugPrintln(Object msg, int level) {
        this.getImpl().debugPrintln(msg, level);
    }

    public String toString() {
        return this.getImpl().toString();
    }

    @Override
    public void setAttribute(Ansi.Attribute attr) {
        this.getImpl().setAttribute(attr);
    }

    @Override
    public void setForegroundColor(Ansi.FColor foreground) {
        this.getImpl().setForegroundColor(foreground);
    }

    @Override
    public void setBackgroundColor(Ansi.BColor background) {
        this.getImpl().setBackgroundColor(background);
    }

    @Override
    public void clear() {
        this.getImpl().clear();
    }

    @Override
    public String generateCode() {
        return this.getImpl().generateCode();
    }

    @Override
    public String generateCode(Ansi.Attribute attr, Ansi.FColor foreground, Ansi.BColor background) {
        return this.getImpl().generateCode(attr, foreground, background);
    }

    @Override
    public void print(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().print(msg, attr, fg, bg);
    }

    @Override
    public void println(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().println(msg, attr, fg, bg);
    }

    @Override
    public void errorPrint(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().errorPrint(msg, attr, fg, bg);
    }

    @Override
    public void errorPrintln(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().errorPrintln(msg, attr, fg, bg);
    }

    @Override
    public void debugPrint(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().debugPrint(msg, attr, fg, bg);
    }

    @Override
    public void debugPrint(Object msg, int level, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().debugPrint(msg, level, attr, fg, bg);
    }

    @Override
    public void debugPrintln(Object msg, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().debugPrintln(msg, attr, fg, bg);
    }

    @Override
    public void debugPrintln(Object msg, int level, Ansi.Attribute attr, Ansi.FColor fg, Ansi.BColor bg) {
        this.getImpl().debugPrintln(msg, level, attr, fg, bg);
    }

    public static class Builder {
        private int _level;
        private boolean _timestampFlag;
        private Ansi.Attribute _attribute = Ansi.Attribute.NONE;
        private Ansi.FColor _foregroundColor = Ansi.FColor.NONE;
        private Ansi.BColor _backgroundColor = Ansi.BColor.NONE;
        private DateFormat _dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

        public Builder(int level, boolean tsFlag) {
            this._level = level;
            this._timestampFlag = tsFlag;
        }

        public Builder level(int level) {
            this._level = level;
            return this;
        }

        public Builder timestamping(boolean flag) {
            this._timestampFlag = flag;
            return this;
        }

        public Builder withFormat(DateFormat df) {
            this._dateFormat = df;
            return this;
        }

        public Builder attribute(Ansi.Attribute attr) {
            this._attribute = attr;
            return this;
        }

        public Builder foreground(Ansi.FColor fg) {
            this._foregroundColor = fg;
            return this;
        }

        public Builder background(Ansi.BColor bg) {
            this._backgroundColor = bg;
            return this;
        }

        public ColoredPrinter build() {
            return new ColoredPrinter(this);
        }
    }
}

