/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.refresh;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.dinuscxj.refresh.IRefreshStatus;

public class RefreshView
extends View
implements IRefreshStatus {
    private static final int MAX_ARC_DEGREE = 330;
    private static final int ANIMATION_DURATION = 888;
    private static final int DEFAULT_START_DEGREES = 285;
    private static final int DEFAULT_STROKE_WIDTH = 2;
    private final RectF mArcBounds = new RectF();
    private final Paint mPaint = new Paint();
    private float mStartDegrees;
    private float mSwipeDegrees;
    private float mStrokeWidth;
    private boolean mHasTriggeredRefresh;
    private ValueAnimator mRotateAnimator;

    public RefreshView(Context context) {
        this(context, null);
    }

    public RefreshView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RefreshView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initData();
        this.initPaint();
    }

    private void initData() {
        float density = this.getResources().getDisplayMetrics().density;
        this.mStrokeWidth = density * 2.0f;
        this.mStartDegrees = 285.0f;
        this.mSwipeDegrees = 0.0f;
    }

    private void initPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setColor(Color.parseColor((String)"#FFD72263"));
    }

    private void startAnimator() {
        this.mRotateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mRotateAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mRotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float rotateProgress = ((Float)animation.getAnimatedValue()).floatValue();
                RefreshView.this.setStartDegrees(285.0f + rotateProgress * 360.0f);
            }
        });
        this.mRotateAnimator.setRepeatMode(1);
        this.mRotateAnimator.setRepeatCount(-1);
        this.mRotateAnimator.setDuration(888L);
        this.mRotateAnimator.start();
    }

    private void resetAnimator() {
        if (this.mRotateAnimator != null) {
            this.mRotateAnimator.cancel();
            this.mRotateAnimator.removeAllUpdateListeners();
            this.mRotateAnimator = null;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawArc(canvas);
    }

    protected void onDetachedFromWindow() {
        this.resetAnimator();
        super.onDetachedFromWindow();
    }

    private void drawArc(Canvas canvas) {
        canvas.drawArc(this.mArcBounds, this.mStartDegrees, this.mSwipeDegrees, false, this.mPaint);
    }

    private void setStartDegrees(float startDegrees) {
        this.mStartDegrees = startDegrees;
        this.postInvalidate();
    }

    public void setSwipeDegrees(float swipeDegrees) {
        this.mSwipeDegrees = swipeDegrees;
        this.postInvalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float radius = (float)Math.min(w, h) / 2.0f;
        float centerX = (float)w / 2.0f;
        float centerY = (float)h / 2.0f;
        this.mArcBounds.set(centerX - radius, centerY - radius, centerX + radius, centerY + radius);
        this.mArcBounds.inset(this.mStrokeWidth / 2.0f, this.mStrokeWidth / 2.0f);
    }

    @Override
    public void reset() {
        this.resetAnimator();
        this.mHasTriggeredRefresh = false;
        this.mStartDegrees = 285.0f;
        this.mSwipeDegrees = 0.0f;
    }

    @Override
    public void refreshing() {
        this.mHasTriggeredRefresh = true;
        this.mSwipeDegrees = 330.0f;
        this.startAnimator();
    }

    @Override
    public void refreshComplete() {
    }

    @Override
    public void pullToRefresh() {
    }

    @Override
    public void releaseToRefresh() {
    }

    @Override
    public void pullProgress(float pullDistance, float pullProgress) {
        if (!this.mHasTriggeredRefresh) {
            float swipeProgress = Math.min(1.0f, pullProgress);
            this.setSwipeDegrees(swipeProgress * 330.0f);
        }
    }
}

