/*
 * Decompiled with CFR 0.152.
 */
package com.dinuscxj.refresh;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import com.dinuscxj.refresh.IDragDistanceConverter;
import com.dinuscxj.refresh.IRefreshStatus;
import com.dinuscxj.refresh.MaterialDragDistanceConverter;
import com.dinuscxj.refresh.RefreshLogger;
import com.dinuscxj.refresh.RefreshView;

public class RecyclerRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final int INVALID_INDEX = -1;
    private static final int INVALID_POINTER = -1;
    private static final int DEFAULT_REFRESH_SIZE_DP = 30;
    private static final int DEFAULT_ANIMATE_DURATION = 300;
    private static final int DEFAULT_REFRESH_TARGET_OFFSET_DP = 50;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private float mTotalUnconsumed;
    private boolean mNestedScrollInProgress;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private boolean mIsAnimatingToStart;
    private boolean mIsRefreshing;
    private boolean mIsFitRefresh;
    private boolean mIsBeingDragged;
    private boolean mNotifyListener;
    private boolean mDispatchTargetTouchDown;
    private int mRefreshViewIndex = -1;
    private int mActivePointerId = -1;
    private int mAnimateToStartDuration = 300;
    private int mAnimateToRefreshDuration = 300;
    private int mFrom;
    private int mTouchSlop;
    private int mRefreshViewSize;
    private float mInitialDownY;
    private float mInitialScrollY;
    private float mInitialMotionY;
    private float mCurrentTouchOffsetY;
    private float mTargetOrRefreshViewOffsetY;
    private float mRefreshInitialOffset;
    private float mRefreshTargetOffset;
    private boolean mUsingCustomRefreshTargetOffset = false;
    private boolean mUsingCustomRefreshInitialOffset = false;
    private boolean mRefreshViewMeasured = false;
    private RefreshStyle mRefreshStyle = RefreshStyle.NORMAL;
    private View mTarget;
    private View mRefreshView;
    private IDragDistanceConverter mDragDistanceConverter;
    private IRefreshStatus mRefreshStatus;
    private OnRefreshListener mOnRefreshListener;
    private Interpolator mAnimateToStartInterpolator = new DecelerateInterpolator(2.0f);
    private Interpolator mAnimateToRefreshInterpolator = new DecelerateInterpolator(2.0f);
    private final Animation mAnimateToRefreshingAnimation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            switch (RecyclerRefreshLayout.this.mRefreshStyle) {
                case FLOAT: {
                    float refreshTargetOffset = RecyclerRefreshLayout.this.mRefreshTargetOffset + RecyclerRefreshLayout.this.mRefreshInitialOffset;
                    RecyclerRefreshLayout.this.animateToTargetOffset(refreshTargetOffset, RecyclerRefreshLayout.this.mRefreshView.getTop(), interpolatedTime);
                    break;
                }
                default: {
                    RecyclerRefreshLayout.this.animateToTargetOffset(RecyclerRefreshLayout.this.mRefreshTargetOffset, RecyclerRefreshLayout.this.mTarget.getTop(), interpolatedTime);
                }
            }
        }
    };
    private final Animation mAnimateToStartAnimation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            switch (RecyclerRefreshLayout.this.mRefreshStyle) {
                case FLOAT: {
                    RecyclerRefreshLayout.this.animateToTargetOffset(RecyclerRefreshLayout.this.mRefreshInitialOffset, RecyclerRefreshLayout.this.mRefreshView.getTop(), interpolatedTime);
                    break;
                }
                default: {
                    RecyclerRefreshLayout.this.animateToTargetOffset(0.0f, RecyclerRefreshLayout.this.mTarget.getTop(), interpolatedTime);
                }
            }
        }
    };
    private final Animation.AnimationListener mRefreshingListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            RecyclerRefreshLayout.this.mIsAnimatingToStart = true;
            RecyclerRefreshLayout.this.mRefreshStatus.refreshing();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (RecyclerRefreshLayout.this.mNotifyListener && RecyclerRefreshLayout.this.mOnRefreshListener != null) {
                RecyclerRefreshLayout.this.mOnRefreshListener.onRefresh();
            }
            RecyclerRefreshLayout.this.mIsAnimatingToStart = false;
        }
    };
    private final Animation.AnimationListener mResetListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            RecyclerRefreshLayout.this.mIsAnimatingToStart = true;
            RecyclerRefreshLayout.this.mRefreshStatus.refreshComplete();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            RecyclerRefreshLayout.this.reset();
        }
    };

    private void animateToTargetOffset(float targetEnd, float currentOffset, float interpolatedTime) {
        int targetOffset = (int)((float)this.mFrom + (targetEnd - (float)this.mFrom) * interpolatedTime);
        this.setTargetOrRefreshViewOffsetY((int)((float)targetOffset - currentOffset));
    }

    public RecyclerRefreshLayout(Context context) {
        this(context, null);
    }

    public RecyclerRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mRefreshViewSize = (int)(30.0f * metrics.density);
        this.mRefreshTargetOffset = 50.0f * metrics.density;
        this.mTargetOrRefreshViewOffsetY = 0.0f;
        this.mRefreshInitialOffset = 0.0f;
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.initRefreshView();
        this.initDragDistanceConverter();
        this.setNestedScrollingEnabled(true);
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
    }

    protected void onDetachedFromWindow() {
        this.reset();
        this.clearAnimation();
        super.onDetachedFromWindow();
    }

    private void reset() {
        this.setTargetOrRefreshViewToInitial();
        this.mCurrentTouchOffsetY = 0.0f;
        this.mRefreshStatus.reset();
        this.mRefreshView.setVisibility(8);
        this.mIsRefreshing = false;
        this.mIsAnimatingToStart = false;
    }

    private void setTargetOrRefreshViewToInitial() {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                this.setTargetOrRefreshViewOffsetY((int)(this.mRefreshInitialOffset - this.mTargetOrRefreshViewOffsetY));
                break;
            }
            default: {
                this.setTargetOrRefreshViewOffsetY((int)(0.0f - this.mTargetOrRefreshViewOffsetY));
            }
        }
    }

    private void initRefreshView() {
        this.mRefreshView = new RefreshView(this.getContext());
        this.mRefreshView.setVisibility(8);
        if (!(this.mRefreshView instanceof IRefreshStatus)) {
            throw new ClassCastException("the refreshView must implement the interface IRefreshStatus");
        }
        this.mRefreshStatus = (IRefreshStatus)this.mRefreshView;
        LayoutParams layoutParams = new LayoutParams(this.mRefreshViewSize, this.mRefreshViewSize);
        this.addView(this.mRefreshView, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initDragDistanceConverter() {
        this.mDragDistanceConverter = new MaterialDragDistanceConverter();
    }

    public void setRefreshView(View refreshView, ViewGroup.LayoutParams layoutParams) {
        if (this.mRefreshView == refreshView) {
            return;
        }
        if (this.mRefreshView != null && this.mRefreshView.getParent() != null) {
            ((ViewGroup)this.mRefreshView.getParent()).removeView(this.mRefreshView);
        }
        if (!(refreshView instanceof IRefreshStatus)) {
            throw new ClassCastException("the refreshView must implement the interface IRefreshStatus");
        }
        this.mRefreshStatus = (IRefreshStatus)refreshView;
        refreshView.setVisibility(8);
        this.addView(refreshView, layoutParams);
        this.mRefreshView = refreshView;
    }

    public void setDragDistanceConverter(@NonNull IDragDistanceConverter dragDistanceConverter) {
        if (dragDistanceConverter == null) {
            throw new NullPointerException("the dragDistanceConverter can't be null");
        }
        this.mDragDistanceConverter = dragDistanceConverter;
    }

    public void setAnimateToStartInterpolator(Interpolator animateToStartInterpolator) {
        if (animateToStartInterpolator == null) {
            return;
        }
        this.mAnimateToStartInterpolator = animateToStartInterpolator;
    }

    public void setAnimateToRefreshInterpolator(Interpolator animateToRefreshInterpolator) {
        if (animateToRefreshInterpolator == null) {
            return;
        }
        this.mAnimateToRefreshInterpolator = animateToRefreshInterpolator;
    }

    public void setAnimateToStartDuration(int animateToStartDuration) {
        this.mAnimateToStartDuration = animateToStartDuration;
    }

    public void setAnimateToRefreshDuration(int animateToRefreshDuration) {
        this.mAnimateToRefreshDuration = animateToRefreshDuration;
    }

    public void setRefreshTargetOffset(float refreshTargetOffset) {
        this.mRefreshTargetOffset = refreshTargetOffset;
        this.mUsingCustomRefreshTargetOffset = true;
        this.requestLayout();
    }

    public void setRefreshInitialOffset(float refreshInitialOffset) {
        this.mRefreshInitialOffset = refreshInitialOffset;
        this.mUsingCustomRefreshInitialOffset = true;
        this.requestLayout();
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                if (this.mRefreshViewIndex < 0) {
                    return i;
                }
                if (i == childCount - 1) {
                    return this.mRefreshViewIndex;
                }
                if (i >= this.mRefreshViewIndex) {
                    return i + 1;
                }
                return i;
            }
        }
        if (this.mRefreshViewIndex < 0) {
            return i;
        }
        if (i == 0) {
            return this.mRefreshViewIndex;
        }
        if (i <= this.mRefreshViewIndex) {
            return i - 1;
        }
        return i;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (!(Build.VERSION.SDK_INT < 21 && this.mTarget instanceof AbsListView || this.mTarget != null && !ViewCompat.isNestedScrollingEnabled((View)this.mTarget))) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return this.isEnabled() && this.canChildScrollUp(this.mTarget) && !this.mIsRefreshing && (nestedScrollAxes & 2) != 0;
            }
        }
        return this.isEnabled() && this.canChildScrollUp(this.mTarget) && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = 0.0f;
        this.mNestedScrollInProgress = true;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int[] parentConsumed;
        if (dy > 0 && this.mTotalUnconsumed > 0.0f) {
            if ((float)dy > this.mTotalUnconsumed) {
                consumed[1] = dy - (int)this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0.0f;
            } else {
                this.mTotalUnconsumed -= (float)dy;
                consumed[1] = dy;
            }
            RefreshLogger.i("pre scroll");
            this.moveSpinner(this.mTotalUnconsumed);
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed = this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (this.mTotalUnconsumed > 0.0f) {
            this.finishSpinner();
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy < 0) {
            this.mTotalUnconsumed += (float)Math.abs(dy);
            RefreshLogger.i("nested scroll");
            this.moveSpinner(this.mTotalUnconsumed);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int targetTop = this.reviseTargetLayoutTop(this.getPaddingTop());
        int targetLeft = this.getPaddingLeft();
        int targetRight = targetLeft + width - this.getPaddingLeft() - this.getPaddingRight();
        int targetBottom = targetTop + height - this.getPaddingTop() - this.getPaddingBottom();
        try {
            this.mTarget.layout(targetLeft, targetTop, targetRight, targetBottom);
        }
        catch (Exception ignored) {
            RefreshLogger.e("error: ignored=" + ignored.toString() + " " + ignored.getStackTrace().toString());
        }
        int refreshViewLeft = (width - this.mRefreshView.getMeasuredWidth()) / 2;
        int refreshViewTop = this.reviseRefreshViewLayoutTop((int)this.mRefreshInitialOffset);
        int refreshViewRight = (width + this.mRefreshView.getMeasuredWidth()) / 2;
        int refreshViewBottom = refreshViewTop + this.mRefreshView.getMeasuredHeight();
        this.mRefreshView.layout(refreshViewLeft, refreshViewTop, refreshViewRight, refreshViewBottom);
        RefreshLogger.i("onLayout: " + left + " : " + top + " : " + right + " : " + bottom);
    }

    private int reviseTargetLayoutTop(int layoutTop) {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return layoutTop;
            }
            case PINNED: {
                return layoutTop + (int)this.mTargetOrRefreshViewOffsetY;
            }
        }
        return layoutTop + (int)this.mTargetOrRefreshViewOffsetY;
    }

    private int reviseRefreshViewLayoutTop(int layoutTop) {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return layoutTop + (int)this.mTargetOrRefreshViewOffsetY;
            }
            case PINNED: {
                return layoutTop;
            }
        }
        return layoutTop + (int)this.mTargetOrRefreshViewOffsetY;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        this.measureTarget();
        this.measureRefreshView(widthMeasureSpec, heightMeasureSpec);
        if (!this.mRefreshViewMeasured && !this.mUsingCustomRefreshInitialOffset) {
            switch (this.mRefreshStyle) {
                case PINNED: {
                    this.mRefreshInitialOffset = 0.0f;
                    this.mTargetOrRefreshViewOffsetY = 0.0f;
                    break;
                }
                case FLOAT: {
                    this.mTargetOrRefreshViewOffsetY = this.mRefreshInitialOffset = (float)(-this.mRefreshView.getMeasuredHeight());
                    break;
                }
                default: {
                    this.mTargetOrRefreshViewOffsetY = 0.0f;
                    this.mRefreshInitialOffset = -this.mRefreshView.getMeasuredHeight();
                }
            }
        }
        if (!this.mRefreshViewMeasured && !this.mUsingCustomRefreshTargetOffset && this.mRefreshTargetOffset < (float)this.mRefreshView.getMeasuredHeight()) {
            this.mRefreshTargetOffset = this.mRefreshView.getMeasuredHeight();
        }
        this.mRefreshViewMeasured = true;
        this.mRefreshViewIndex = -1;
        for (int index = 0; index < this.getChildCount(); ++index) {
            if (this.getChildAt(index) != this.mRefreshView) continue;
            this.mRefreshViewIndex = index;
            break;
        }
    }

    private void measureTarget() {
        this.mTarget.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
    }

    private void measureRefreshView(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mRefreshView.getLayoutParams();
        if (lp.width == -1) {
            int width = Math.max(0, this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - lp.leftMargin - lp.rightMargin);
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        } else {
            childWidthMeasureSpec = RecyclerRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
        }
        if (lp.height == -1) {
            int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - lp.topMargin - lp.bottomMargin);
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        } else {
            childHeightMeasureSpec = RecyclerRefreshLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
        }
        this.mRefreshView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 1: 
            case 3: {
                this.onStopNestedScroll((View)this);
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return false;
        }
        switch (this.mRefreshStyle) {
            case FLOAT: {
                if (this.isEnabled() && !this.canChildScrollUp(this.mTarget) && !this.mIsRefreshing && !this.mNestedScrollInProgress) break;
                return false;
            }
            default: {
                if (this.isEnabled() && (!this.canChildScrollUp(this.mTarget) || this.mDispatchTargetTouchDown)) break;
                return false;
            }
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialDownY == -1.0f) {
                    return false;
                }
                if (this.mAnimateToRefreshingAnimation.hasEnded() && this.mAnimateToStartAnimation.hasEnded()) {
                    this.mIsAnimatingToStart = false;
                }
                this.mInitialDownY = initialDownY;
                this.mInitialScrollY = this.mTargetOrRefreshViewOffsetY;
                this.mDispatchTargetTouchDown = false;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float activeMoveY = this.getMotionEventY(ev, this.mActivePointerId);
                if (activeMoveY == -1.0f) {
                    return false;
                }
                this.initDragStatus(activeMoveY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                break;
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return false;
        }
        switch (this.mRefreshStyle) {
            case FLOAT: {
                if (this.isEnabled() && !this.canChildScrollUp(this.mTarget) && !this.mNestedScrollInProgress) break;
                return false;
            }
            default: {
                if (this.isEnabled() && (!this.canChildScrollUp(this.mTarget) || this.mDispatchTargetTouchDown)) break;
                return false;
            }
        }
        if (this.mRefreshStyle == RefreshStyle.FLOAT && (this.canChildScrollUp(this.mTarget) || this.mNestedScrollInProgress)) {
            return false;
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                break;
            }
            case 2: {
                float overScrollY;
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float activeMoveY = this.getMotionEventY(ev, this.mActivePointerId);
                if (activeMoveY == -1.0f) {
                    return false;
                }
                if (this.mIsAnimatingToStart) {
                    overScrollY = this.getTargetOrRefreshViewTop();
                    this.mInitialMotionY = activeMoveY;
                    this.mInitialScrollY = overScrollY;
                    RefreshLogger.i("animatetostart overscrolly " + overScrollY + " -- " + this.mInitialMotionY);
                } else {
                    overScrollY = activeMoveY - this.mInitialMotionY + this.mInitialScrollY;
                    RefreshLogger.i("overscrolly " + overScrollY + " --" + this.mInitialMotionY + " -- " + this.mInitialScrollY);
                }
                if (this.mIsRefreshing) {
                    if (overScrollY <= 0.0f) {
                        if (this.mDispatchTargetTouchDown) {
                            this.mTarget.dispatchTouchEvent(ev);
                        } else {
                            MotionEvent obtain = MotionEvent.obtain((MotionEvent)ev);
                            obtain.setAction(0);
                            this.mDispatchTargetTouchDown = true;
                            this.mTarget.dispatchTouchEvent(obtain);
                        }
                    } else if (overScrollY > 0.0f && overScrollY < this.mRefreshTargetOffset && this.mDispatchTargetTouchDown) {
                        MotionEvent obtain = MotionEvent.obtain((MotionEvent)ev);
                        obtain.setAction(3);
                        this.mDispatchTargetTouchDown = false;
                        this.mTarget.dispatchTouchEvent(obtain);
                    }
                    RefreshLogger.i("moveSpinner refreshing -- " + this.mInitialScrollY + " -- " + (activeMoveY - this.mInitialMotionY));
                    this.moveSpinner(overScrollY);
                    break;
                }
                if (this.mIsBeingDragged) {
                    if (overScrollY > 0.0f) {
                        this.moveSpinner(overScrollY);
                        break;
                    }
                    return false;
                }
                this.initDragStatus(activeMoveY);
                break;
            }
            case 5: {
                this.onNewerPointerDown(ev);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1 || this.getMotionEventY(ev, this.mActivePointerId) == -1.0f) {
                    this.resetTouchEvent();
                    return false;
                }
                if (this.mIsRefreshing || this.mIsAnimatingToStart) {
                    if (this.mDispatchTargetTouchDown) {
                        this.mTarget.dispatchTouchEvent(ev);
                    }
                    this.resetTouchEvent();
                    return false;
                }
                this.resetTouchEvent();
                this.finishSpinner();
                return false;
            }
        }
        return true;
    }

    private void resetTouchEvent() {
        this.mInitialScrollY = 0.0f;
        this.mIsBeingDragged = false;
        this.mDispatchTargetTouchDown = false;
        this.mActivePointerId = -1;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.mIsRefreshing != refreshing) {
            this.mIsRefreshing = refreshing;
            this.mNotifyListener = false;
            this.animateToRefreshingPosition((int)this.mTargetOrRefreshViewOffsetY, this.mRefreshingListener);
        } else {
            this.setRefreshing(refreshing, false);
        }
    }

    private void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mIsRefreshing != refreshing) {
            this.mNotifyListener = notify;
            this.mIsRefreshing = refreshing;
            if (refreshing) {
                this.animateToRefreshingPosition((int)this.mTargetOrRefreshViewOffsetY, this.mRefreshingListener);
            } else {
                this.animateOffsetToStartPosition((int)this.mTargetOrRefreshViewOffsetY, this.mResetListener);
            }
        }
    }

    private void initDragStatus(float activeMoveY) {
        float diff = activeMoveY - this.mInitialDownY;
        if (this.mIsRefreshing && (diff > (float)this.mTouchSlop || this.mTargetOrRefreshViewOffsetY > 0.0f)) {
            this.mIsBeingDragged = true;
            this.mInitialMotionY = this.mInitialDownY + (float)this.mTouchSlop;
        } else if (!this.mIsBeingDragged && diff > (float)this.mTouchSlop) {
            this.mInitialMotionY = this.mInitialDownY + (float)this.mTouchSlop;
            this.mIsBeingDragged = true;
        }
    }

    private void animateOffsetToStartPosition(int from, Animation.AnimationListener listener) {
        this.clearAnimation();
        if (this.computeAnimateToStartDuration(from) <= 0) {
            listener.onAnimationStart(null);
            listener.onAnimationEnd(null);
            return;
        }
        this.mFrom = from;
        this.mAnimateToStartAnimation.reset();
        this.mAnimateToStartAnimation.setDuration((long)this.computeAnimateToStartDuration(from));
        this.mAnimateToStartAnimation.setInterpolator(this.mAnimateToStartInterpolator);
        if (listener != null) {
            this.mAnimateToStartAnimation.setAnimationListener(listener);
        }
        this.startAnimation(this.mAnimateToStartAnimation);
    }

    private void animateToRefreshingPosition(int from, Animation.AnimationListener listener) {
        this.clearAnimation();
        if (this.computeAnimateToRefreshingDuration(from) <= 0) {
            listener.onAnimationStart(null);
            listener.onAnimationEnd(null);
            return;
        }
        this.mFrom = from;
        this.mAnimateToRefreshingAnimation.reset();
        this.mAnimateToRefreshingAnimation.setDuration((long)this.computeAnimateToRefreshingDuration(from));
        this.mAnimateToRefreshingAnimation.setInterpolator(this.mAnimateToRefreshInterpolator);
        if (listener != null) {
            this.mAnimateToRefreshingAnimation.setAnimationListener(listener);
        }
        this.startAnimation(this.mAnimateToRefreshingAnimation);
    }

    private int computeAnimateToRefreshingDuration(float from) {
        RefreshLogger.i("from -- refreshing " + from);
        if (from < this.mRefreshInitialOffset) {
            return 0;
        }
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return (int)(Math.max(0.0f, Math.min(1.0f, Math.abs(from - this.mRefreshInitialOffset - this.mRefreshTargetOffset) / this.mRefreshTargetOffset)) * (float)this.mAnimateToRefreshDuration);
            }
        }
        return (int)(Math.max(0.0f, Math.min(1.0f, Math.abs(from - this.mRefreshTargetOffset) / this.mRefreshTargetOffset)) * (float)this.mAnimateToRefreshDuration);
    }

    private int computeAnimateToStartDuration(float from) {
        RefreshLogger.i("from -- start " + from);
        if (from < this.mRefreshInitialOffset) {
            return 0;
        }
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return (int)(Math.max(0.0f, Math.min(1.0f, Math.abs(from - this.mRefreshInitialOffset) / this.mRefreshTargetOffset)) * (float)this.mAnimateToStartDuration);
            }
        }
        return (int)(Math.max(0.0f, Math.min(1.0f, Math.abs(from) / this.mRefreshTargetOffset)) * (float)this.mAnimateToStartDuration);
    }

    private void moveSpinner(float targetOrRefreshViewOffsetY) {
        float refreshTargetOffset;
        float convertScrollOffset;
        this.mCurrentTouchOffsetY = targetOrRefreshViewOffsetY;
        if (!this.mIsRefreshing) {
            switch (this.mRefreshStyle) {
                case FLOAT: {
                    convertScrollOffset = this.mRefreshInitialOffset + this.mDragDistanceConverter.convert(targetOrRefreshViewOffsetY, this.mRefreshTargetOffset);
                    refreshTargetOffset = this.mRefreshTargetOffset;
                    break;
                }
                default: {
                    convertScrollOffset = this.mDragDistanceConverter.convert(targetOrRefreshViewOffsetY, this.mRefreshTargetOffset);
                    refreshTargetOffset = this.mRefreshTargetOffset;
                    break;
                }
            }
        } else {
            convertScrollOffset = targetOrRefreshViewOffsetY > this.mRefreshTargetOffset ? this.mRefreshTargetOffset : targetOrRefreshViewOffsetY;
            if (convertScrollOffset < 0.0f) {
                convertScrollOffset = 0.0f;
            }
            refreshTargetOffset = this.mRefreshTargetOffset;
        }
        if (!this.mIsRefreshing) {
            if (convertScrollOffset > refreshTargetOffset && !this.mIsFitRefresh) {
                this.mIsFitRefresh = true;
                this.mRefreshStatus.pullToRefresh();
            } else if (convertScrollOffset <= refreshTargetOffset && this.mIsFitRefresh) {
                this.mIsFitRefresh = false;
                this.mRefreshStatus.releaseToRefresh();
            }
        }
        RefreshLogger.i(targetOrRefreshViewOffsetY + " -- " + refreshTargetOffset + " -- " + convertScrollOffset + " -- " + this.mTargetOrRefreshViewOffsetY + " -- " + this.mRefreshTargetOffset);
        this.setTargetOrRefreshViewOffsetY((int)(convertScrollOffset - this.mTargetOrRefreshViewOffsetY));
    }

    private void finishSpinner() {
        if (this.mIsRefreshing || this.mIsAnimatingToStart) {
            return;
        }
        float scrollY = this.getTargetOrRefreshViewOffset();
        if (scrollY > this.mRefreshTargetOffset) {
            this.setRefreshing(true, true);
        } else {
            this.mIsRefreshing = false;
            this.animateOffsetToStartPosition((int)this.mTargetOrRefreshViewOffsetY, this.mResetListener);
        }
    }

    private void onNewerPointerDown(MotionEvent ev) {
        int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
        this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
        this.mInitialMotionY = this.getMotionEventY(ev, this.mActivePointerId) - this.mCurrentTouchOffsetY;
        RefreshLogger.i(" onDown " + this.mInitialMotionY);
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
        this.mInitialMotionY = this.getMotionEventY(ev, this.mActivePointerId) - this.mCurrentTouchOffsetY;
        RefreshLogger.i(" onUp " + this.mInitialMotionY);
    }

    private void setTargetOrRefreshViewOffsetY(int offsetY) {
        if (this.mTarget == null) {
            return;
        }
        switch (this.mRefreshStyle) {
            case FLOAT: {
                this.mRefreshView.offsetTopAndBottom(offsetY);
                this.mTargetOrRefreshViewOffsetY = this.mRefreshView.getTop();
                break;
            }
            case PINNED: {
                this.mTarget.offsetTopAndBottom(offsetY);
                this.mTargetOrRefreshViewOffsetY = this.mTarget.getTop();
                break;
            }
            default: {
                this.mTarget.offsetTopAndBottom(offsetY);
                this.mRefreshView.offsetTopAndBottom(offsetY);
                this.mTargetOrRefreshViewOffsetY = this.mTarget.getTop();
            }
        }
        RefreshLogger.i("current offset" + this.mTargetOrRefreshViewOffsetY);
        switch (this.mRefreshStyle) {
            case FLOAT: {
                this.mRefreshStatus.pullProgress(this.mTargetOrRefreshViewOffsetY, (this.mTargetOrRefreshViewOffsetY - this.mRefreshInitialOffset) / this.mRefreshTargetOffset);
                break;
            }
            default: {
                this.mRefreshStatus.pullProgress(this.mTargetOrRefreshViewOffsetY, this.mTargetOrRefreshViewOffsetY / this.mRefreshTargetOffset);
            }
        }
        if (this.mRefreshView.getVisibility() != 0) {
            this.mRefreshView.setVisibility(0);
        }
        this.invalidate();
    }

    private int getTargetOrRefreshViewTop() {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return this.mRefreshView.getTop();
            }
        }
        return this.mTarget.getTop();
    }

    private int getTargetOrRefreshViewOffset() {
        switch (this.mRefreshStyle) {
            case FLOAT: {
                return (int)((float)this.mRefreshView.getTop() - this.mRefreshInitialOffset);
            }
        }
        return this.mTarget.getTop();
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    private boolean canChildScrollUp(View mTarget) {
        if (mTarget == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14 && mTarget instanceof AbsListView) {
            AbsListView absListView = (AbsListView)mTarget;
            return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
        }
        if (mTarget instanceof ViewGroup) {
            int childCount = ((ViewGroup)mTarget).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = ((ViewGroup)mTarget).getChildAt(i);
                if (!this.canChildScrollUp(child)) continue;
                return true;
            }
        }
        return ViewCompat.canScrollVertically((View)mTarget, (int)-1);
    }

    private void ensureTarget() {
        if (!this.isTargetValid()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.equals(this.mRefreshView)) continue;
                this.mTarget = child;
                break;
            }
        }
    }

    private boolean isTargetValid() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.mTarget != this.getChildAt(i)) continue;
            return true;
        }
        return false;
    }

    public void setRefreshStyle(@NonNull RefreshStyle refreshStyle) {
        this.mRefreshStyle = refreshStyle;
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }

    public static enum RefreshStyle {
        NORMAL,
        PINNED,
        FLOAT;

    }
}

