/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.codec.DateTimeCodec;
import shade.com.alibaba.fastjson2.writer.ObjectWriter;

final class ObjectWriterImplLocalDate
extends DateTimeCodec
implements ObjectWriter {
    static final ObjectWriterImplLocalDate INSTANCE = new ObjectWriterImplLocalDate(null, null);

    private ObjectWriterImplLocalDate(String format, Locale locale) {
        super(format, locale);
    }

    public static ObjectWriterImplLocalDate of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectWriterImplLocalDate(format, locale);
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        jsonWriter.writeLocalDate((LocalDate)object);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        JSONWriter.Context ctx = jsonWriter.context;
        LocalDate date = (LocalDate)object;
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
            long millis = dateTime.atZone(ctx.getZoneId()).toInstant().toEpochMilli();
            jsonWriter.writeInt64(millis / 1000L);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.MIN);
            long millis = dateTime.atZone(ctx.getZoneId()).toInstant().toEpochMilli();
            jsonWriter.writeInt64(millis);
            return;
        }
        if (this.yyyyMMdd8) {
            jsonWriter.writeDateYYYMMDD8(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            return;
        }
        if (this.yyyyMMdd10) {
            jsonWriter.writeDateYYYMMDD10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            return;
        }
        if (this.yyyyMMddhhmmss19) {
            jsonWriter.writeDateTime19(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0);
            return;
        }
        DateTimeFormatter formatter = this.getDateFormatter();
        if (formatter == null) {
            formatter = ctx.getDateFormatter();
        }
        if (formatter == null) {
            jsonWriter.writeDateYYYMMDD10(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            return;
        }
        String str = this.formatHasHour || ctx.isDateFormatHasHour() ? formatter.format(LocalDateTime.of(date, LocalTime.MIN)) : formatter.format(date);
        jsonWriter.writeString(str);
    }
}

