/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalTime;
import shade.com.alibaba.fastjson2.util.JDKUtils;

public class IOUtils {
    public static final int NULL_32;
    public static final long NULL_64;
    public static final int TRUE;
    public static final long TRUE_64;
    public static final int ALSE;
    public static final long ALSE_64;
    public static final long DOT_X0;
    static final int[] sizeTable;
    public static final int[] DIGITS_K_32;
    public static final long[] DIGITS_K_64;
    private static final byte[] MIN_INT_BYTES;
    private static final char[] MIN_INT_CHARS;
    private static final byte[] MIN_LONG;
    public static final short[] PACKED_DIGITS;
    public static final int[] PACKED_DIGITS_UTF16;
    static final long[] POWER_TEN;

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void getChars(int i, int index, byte[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            int q = i / 100;
            int r = q * 100 - i;
            i = q;
            JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)(charPos -= 2), PACKED_DIGITS[r]);
        }
        if (i < -9) {
            JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)(charPos -= 2), PACKED_DIGITS[-i]);
        } else {
            buf[--charPos] = (byte)(48 - i);
        }
        if (negative) {
            buf[charPos - 1] = 45;
        }
    }

    public static void getChars(int i, int index, char[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            int q = i / 100;
            int r = q * 100 - i;
            i = q;
            JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)((charPos -= 2) << 1), PACKED_DIGITS_UTF16[r]);
        }
        if (i < -9) {
            JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)((charPos -= 2) << 1), PACKED_DIGITS_UTF16[-i]);
        } else {
            buf[--charPos] = (char)(48 - i);
        }
        if (negative) {
            buf[charPos - 1] = 45;
        }
    }

    public static void getChars(long i, int index, byte[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)(charPos -= 2), PACKED_DIGITS[(int)(q * 100L - i)]);
            i = q;
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q2 = i2 / 100;
            JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)(charPos -= 2), PACKED_DIGITS[q2 * 100 - i2]);
            i2 = q2;
        }
        if (i2 < -9) {
            JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)(charPos -= 2), PACKED_DIGITS[-i2]);
        } else {
            buf[--charPos] = (byte)(48 - i2);
        }
        if (negative) {
            buf[charPos - 1] = 45;
        }
    }

    public static void getChars(long i, int index, char[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)((charPos -= 2) << 1), PACKED_DIGITS_UTF16[(int)(q * 100L - i)]);
            i = q;
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q2 = i2 / 100;
            JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)((charPos -= 2) << 1), PACKED_DIGITS_UTF16[q2 * 100 - i2]);
            i2 = q2;
        }
        if (i2 < -9) {
            JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)((charPos -= 2) << 1), PACKED_DIGITS_UTF16[-i2]);
        } else {
            buf[--charPos] = (char)(48 - i2);
        }
        if (negative) {
            buf[--charPos] = 45;
        }
    }

    public static int writeDecimal(byte[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            buf[off++] = 45;
            unscaledVal = -unscaledVal;
        }
        if (scale != 0) {
            int unscaleValSize = IOUtils.stringSize(unscaledVal);
            int insertionPoint = unscaleValSize - scale;
            if (insertionPoint == 0) {
                buf[off] = 48;
                buf[off + 1] = 46;
                off += 2;
            } else if (insertionPoint < 0) {
                buf[off] = 48;
                buf[off + 1] = 46;
                off += 2;
                for (int i = 0; i < -insertionPoint; ++i) {
                    buf[off++] = 48;
                }
            } else {
                long power = POWER_TEN[scale - 1];
                long div = unscaledVal / power;
                long rem = unscaledVal - div * power;
                off = IOUtils.writeInt64(buf, off, div);
                buf[off] = 46;
                if (scale == 1) {
                    buf[off + 1] = (byte)(rem + 48L);
                    return off + 2;
                }
                if (scale == 2) {
                    JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 1L, PACKED_DIGITS[(int)rem]);
                    return off + 3;
                }
                int end = unscaleValSize - IOUtils.stringSize(rem) - insertionPoint;
                for (int i = 0; i < end; ++i) {
                    buf[++off] = 48;
                }
                return IOUtils.writeInt64(buf, off + 1, rem);
            }
        }
        return IOUtils.writeInt64(buf, off, unscaledVal);
    }

    public static int writeDecimal(char[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            buf[off++] = 45;
            unscaledVal = -unscaledVal;
        }
        if (scale != 0) {
            int unscaleValSize = IOUtils.stringSize(unscaledVal);
            int insertionPoint = unscaleValSize - scale;
            if (insertionPoint == 0) {
                buf[off] = 48;
                buf[off + 1] = 46;
                off += 2;
            } else if (insertionPoint < 0) {
                buf[off] = 48;
                buf[off + 1] = 46;
                off += 2;
                for (int i = 0; i < -insertionPoint; ++i) {
                    buf[off++] = 48;
                }
            } else {
                long power = POWER_TEN[scale - 1];
                long div = unscaledVal / power;
                long rem = unscaledVal - div * power;
                off = IOUtils.writeInt64(buf, off, div);
                buf[off] = 46;
                if (scale == 1) {
                    buf[off + 1] = (char)(rem + 48L);
                    return off + 2;
                }
                if (scale == 2) {
                    JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 1 << 1), PACKED_DIGITS_UTF16[(int)rem]);
                    return off + 3;
                }
                int end = unscaleValSize - IOUtils.stringSize(rem) - insertionPoint;
                for (int i = 0; i < end; ++i) {
                    buf[++off] = 48;
                }
                return IOUtils.writeInt64(buf, off + 1, rem);
            }
        }
        return IOUtils.writeInt64(buf, off, unscaledVal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encodeUTF8(byte[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        while (offset < sl) {
            byte b0 = src[offset];
            byte b1 = src[offset + 1];
            offset += 2;
            if (b1 == 0 && b0 >= 0) {
                dst[dp++] = b0;
                continue;
            }
            char c = (char)(b0 & 0xFF | (b1 & 0xFF) << 8);
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c < '\ue000') {
                int uc;
                int ip = offset - 1;
                if (c >= '\udc00') return -1;
                if (sl - ip < 2) {
                    uc = -1;
                } else {
                    b0 = src[ip + 1];
                    b1 = src[ip + 2];
                    char d = (char)(b0 & 0xFF | (b1 & 0xFF) << 8);
                    if (d < '\udc00' || d >= '\ue000') return -1;
                    offset += 2;
                    uc = (c << 10) + d + -56613888;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp] = (byte)(0xF0 | uc >> 18);
                dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
                dp += 4;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        int dlASCII = dp + Math.min(len, dst.length);
        while (dp < dlASCII && src[offset] < '\u0080') {
            dst[dp++] = (byte)src[offset++];
        }
        while (true) {
            char c;
            block11: {
                int uc;
                block10: {
                    block12: {
                        if (offset >= sl) {
                            return dp;
                        }
                        if ((c = src[offset++]) < '\u0080') {
                            dst[dp++] = (byte)c;
                            continue;
                        }
                        if (c < '\u0800') {
                            dst[dp] = (byte)(0xC0 | c >> 6);
                            dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                            dp += 2;
                            continue;
                        }
                        if (c < '\ud800' || c >= '\ue000') break block11;
                        int ip = offset - 1;
                        if (c >= '\udc00') break block12;
                        if (sl - ip < 2) {
                            uc = -1;
                            break block10;
                        } else {
                            char d = src[ip + 1];
                            if (d >= '\udc00' && d < '\ue000') {
                                uc = (c << 10) + d + -56613888;
                                break block10;
                            } else {
                                dst[dp++] = 63;
                                continue;
                            }
                        }
                    }
                    dst[dp++] = 63;
                    continue;
                }
                if (uc < 0) {
                    dst[dp++] = 63;
                    continue;
                }
                dst[dp] = (byte)(0xF0 | uc >> 18);
                dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
                dp += 4;
                ++offset;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(byte[] chars, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = (char)chars[i];
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int decodeUTF8(byte[] src, int off, int len, byte[] dst) {
        int sl = off + len;
        int dp = 0;
        while (off < sl) {
            byte b1;
            byte b0;
            if ((b0 = src[off++]) >= 0) {
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b1 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                break;
            }
            if (b0 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b1 = src[off];
                    byte b2 = src[off + 1];
                    off += 2;
                    if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            if (b0 >> 3 == -2) {
                if (off + 2 < sl) {
                    byte b2 = src[off];
                    byte b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    char c = (char)((uc >>> 10) + 55232);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    c = (char)((uc & 0x3FF) + 56320);
                    dst[dp += 2] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int decodeUTF8(byte[] src, int off, int len, char[] dst) {
        int sl = off + len;
        int dp = 0;
        int dlASCII = Math.min(len, dst.length);
        while (dp < dlASCII && src[off] >= 0) {
            dst[dp++] = (char)src[off++];
        }
        while (off < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[off++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b2 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b2 = src[off];
                    b3 = src[off + 1];
                    off += 2;
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (off + 2 < sl) {
                    b2 = src[off];
                    b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    dst[dp] = (char)((uc >>> 10) + 55232);
                    dst[dp + 1] = (char)((uc & 0x3FF) + 56320);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static long lines(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            long l = IOUtils.lines(in);
            return l;
        }
    }

    public static long lines(InputStream in) throws Exception {
        int len;
        long lines = 0L;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            for (int i = 0; i < len; ++i) {
                byte b = buf[i];
                if (b != 10) continue;
                ++lines;
            }
        }
        return lines;
    }

    public static int writeLocalDate(byte[] bytes, int off, int year, int month, int dayOfMonth) {
        if (year < 0) {
            bytes[off++] = 45;
            year = -year;
        } else if (year > 9999) {
            bytes[off++] = 43;
        }
        if (year < 10000) {
            int y01 = year / 100;
            int y23 = year - y01 * 100;
            JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, PACKED_DIGITS[y01]);
            JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 2L, PACKED_DIGITS[y23]);
            off += 4;
        } else {
            off = IOUtils.writeInt32(bytes, off, year);
        }
        bytes[off] = 45;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 1L, PACKED_DIGITS[month]);
        bytes[off + 3] = 45;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 4L, PACKED_DIGITS[dayOfMonth]);
        return off + 6;
    }

    public static int writeLocalDate(char[] chars, int off, int year, int month, int dayOfMonth) {
        if (year < 0) {
            chars[off++] = 45;
            year = -year;
        } else if (year > 9999) {
            chars[off++] = 43;
        }
        if (year < 10000) {
            int y01 = year / 100;
            int y23 = year - y01 * 100;
            JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off << 1), PACKED_DIGITS_UTF16[y01]);
            JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 2 << 1), PACKED_DIGITS_UTF16[y23]);
            off += 4;
        } else {
            off = IOUtils.writeInt32(chars, off, year);
        }
        chars[off] = 45;
        JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 1 << 1), PACKED_DIGITS_UTF16[month]);
        chars[off + 3] = 45;
        JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 4 << 1), PACKED_DIGITS_UTF16[dayOfMonth]);
        return off + 6;
    }

    public static void writeLocalTime(byte[] bytes, int off, int hour, int minute, int second) {
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, PACKED_DIGITS[hour]);
        bytes[off + 2] = 58;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 3L, PACKED_DIGITS[minute]);
        bytes[off + 5] = 58;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off + 6L, PACKED_DIGITS[second]);
    }

    public static int writeLocalTime(byte[] bytes, int off, LocalTime time) {
        IOUtils.writeLocalTime(bytes, off, time.getHour(), time.getMinute(), time.getSecond());
        int nano = time.getNano();
        return nano != 0 ? IOUtils.writeNano(bytes, off, nano) : (off += 8);
    }

    public static int writeNano(byte[] bytes, int off, int nano) {
        int v;
        int div = nano / 1000;
        int div2 = div / 1000;
        int rem1 = nano - div * 1000;
        IOUtils.putInt(bytes, off, DIGITS_K_32[div2] & 0xFFFFFF00 | 0x2E);
        off += 4;
        if (rem1 == 0) {
            int rem2 = div - div2 * 1000;
            if (rem2 == 0) {
                return off;
            }
            v = DIGITS_K_32[rem2];
        } else {
            v = DIGITS_K_32[div - div2 * 1000];
        }
        bytes[off] = (byte)(v >> 8);
        bytes[off + 1] = (byte)(v >> 16);
        off += 2;
        if (rem1 == 0) {
            bytes[off] = (byte)(v >> 24);
            return off + 1;
        }
        IOUtils.putInt(bytes, off, DIGITS_K_32[rem1] & 0xFFFFFF00 | v >> 24);
        return off + 4;
    }

    public static int writeNano(char[] chars, int off, int nano) {
        long v;
        int div = nano / 1000;
        int div2 = div / 1000;
        int rem1 = nano - div * 1000;
        IOUtils.putLong(chars, off, DIGITS_K_64[div2] & 0xFFFFFFFFFFFF0000L | DOT_X0);
        off += 4;
        if (rem1 == 0) {
            int rem2 = div - div2 * 1000;
            if (rem2 == 0) {
                return off;
            }
            v = DIGITS_K_64[rem2];
        } else {
            v = DIGITS_K_64[div - div2 * 1000];
        }
        chars[off] = (char)(v >> 16);
        chars[off + 1] = (char)(v >> 32);
        off += 2;
        if (rem1 == 0) {
            chars[off] = (char)(v >> 48);
            return off + 1;
        }
        IOUtils.putLong(chars, off, DIGITS_K_64[rem1] & 0xFFFFFFFFFFFF0000L | v >> 48);
        return off + 4;
    }

    public static void writeLocalTime(char[] chars, int off, int hour, int minute, int second) {
        JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off << 1), PACKED_DIGITS_UTF16[hour]);
        chars[off + 2] = 58;
        JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 3 << 1), PACKED_DIGITS_UTF16[minute]);
        chars[off + 5] = 58;
        JDKUtils.UNSAFE.putInt(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(off + 6 << 1), PACKED_DIGITS_UTF16[second]);
    }

    public static int writeLocalTime(char[] chars, int off, LocalTime time) {
        IOUtils.writeLocalTime(chars, off, time.getHour(), time.getMinute(), time.getSecond());
        int nano = time.getNano();
        return nano != 0 ? IOUtils.writeNano(chars, off, nano) : (off += 8);
    }

    public static int writeInt64(byte[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG, 0, buf, pos, MIN_LONG.length);
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000L) {
            int v = DIGITS_K_32[(int)i];
            int start = v & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v >> 8);
                buf[pos + 1] = (byte)(v >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 16);
            }
            buf[pos++] = (byte)(v >> 24);
            return pos;
        }
        long q1 = i / 1000L;
        int r1 = (int)(i - q1 * 1000L);
        int v1 = DIGITS_K_32[r1];
        if (i < 1000000L) {
            int v2 = DIGITS_K_32[(int)q1];
            int start = v2 & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v2 >> 8);
                buf[pos + 1] = (byte)(v2 >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v2 >> 16);
            }
            IOUtils.putInt(buf, pos, v1 & 0xFFFFFF00 | v2 >> 24);
            return pos + 4;
        }
        long q2 = q1 / 1000L;
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        int v2 = DIGITS_K_32[r2];
        if (q3 == 0L) {
            int v3 = DIGITS_K_32[(int)q2];
            int start = v3 & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v3 >> 8);
                buf[pos + 1] = (byte)(v3 >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v3 >> 16);
            }
            buf[pos] = (byte)(v3 >> 24);
            buf[pos + 1] = (byte)(v2 >> 8);
            buf[pos + 2] = (byte)(v2 >> 16);
            IOUtils.putInt(buf, pos + 3, v1 & 0xFFFFFF00 | v2 >> 24);
            return pos + 7;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        int v3 = DIGITS_K_32[r3];
        if (q4 == 0) {
            int v4 = DIGITS_K_32[(int)q3];
            int start = v4 & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v4 >> 8);
                buf[pos + 1] = (byte)(v4 >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v4 >> 16);
            }
            buf[pos] = (byte)(v4 >> 24);
            buf[pos + 1] = (byte)(v3 >> 8);
            IOUtils.putInt(buf, pos + 2, (v2 & 0xFFFF00) << 8 | v3 >> 16);
            IOUtils.putInt(buf, pos + 6, v1 & 0xFFFFFF00 | v2 >> 24);
            return pos + 10;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        int v4 = DIGITS_K_32[r4];
        if (q5 == 0) {
            int v5 = DIGITS_K_32[q4];
            int start = v5 & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v5 >> 8);
                buf[pos + 1] = (byte)(v5 >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v5 >> 16);
            }
            IOUtils.putInt(buf, pos, v4 & 0xFFFFFF00 | v5 >> 24);
            buf[pos + 4] = (byte)(v3 >> 8);
            IOUtils.putInt(buf, pos + 5, (v2 & 0xFFFF00) << 8 | v3 >> 16);
            IOUtils.putInt(buf, pos + 9, v1 & 0xFFFFFF00 | v2 >> 24);
            return pos + 13;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v5 = DIGITS_K_32[r5];
        if (q6 == 0) {
            int v = DIGITS_K_32[q5];
            int start = v & 0xFF;
            if (start == 0) {
                buf[pos] = (byte)(v >> 8);
                buf[pos + 1] = (byte)(v >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 16);
            }
            buf[pos++] = (byte)(v >> 24);
        } else {
            IOUtils.putInt(buf, pos, DIGITS_K_32[q5 - q6 * 1000] & 0xFFFFFF00 | q6 + 48);
            pos += 4;
        }
        buf[pos] = (byte)(v5 >> 8);
        IOUtils.putInt(buf, pos + 1, (v4 & 0xFFFF00) << 8 | v5 >> 16);
        IOUtils.putInt(buf, pos + 5, v3 & 0xFFFFFF00 | v4 >> 24);
        buf[pos + 9] = (byte)(v2 >> 8);
        buf[pos + 10] = (byte)(v2 >> 16);
        IOUtils.putInt(buf, pos + 11, v1 & 0xFFFFFF00 | v2 >> 24);
        return pos + 15;
    }

    public static int writeInt64(char[] buf, int pos, long value) {
        long i;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                for (int x = 0; x < MIN_LONG.length; ++x) {
                    buf[pos + x] = (char)MIN_LONG[x];
                }
                return pos + MIN_LONG.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000L) {
            long v = DIGITS_K_64[(int)i];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 32);
            }
            buf[pos++] = (char)(v >> 48);
            return pos;
        }
        long q1 = i / 1000L;
        int r1 = (int)(i - q1 * 1000L);
        long v1 = DIGITS_K_64[r1];
        if (i < 1000000L) {
            long v2 = DIGITS_K_64[(int)q1];
            byte start = (byte)v2;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v2 >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v2 >> 32);
            }
            IOUtils.putLong(buf, pos, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
            return pos + 4;
        }
        long q2 = q1 / 1000L;
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        long v2 = DIGITS_K_64[r2];
        if (q3 == 0L) {
            long v3 = DIGITS_K_64[(int)q2];
            byte start = (byte)v3;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v3 >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v3 >> 32);
            }
            buf[pos] = (char)(v3 >> 48);
            IOUtils.putInt(buf, pos + 1, (int)(v2 >> 16));
            IOUtils.putLong(buf, pos + 3, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
            return pos + 7;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        long v3 = DIGITS_K_64[r3];
        if (q4 == 0) {
            long v4 = DIGITS_K_64[(int)q3];
            byte start = (byte)v4;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v4 >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v4 >> 32);
            }
            buf[pos] = (char)(v4 >> 48);
            buf[pos + 1] = (char)(v3 >> 16);
            IOUtils.putLong(buf, pos + 2, (v2 & 0xFFFFFFFF0000L) << 16 | v3 >> 32);
            IOUtils.putLong(buf, pos + 6, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
            return pos + 10;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        long v4 = DIGITS_K_64[r4];
        if (q5 == 0) {
            long v5 = DIGITS_K_64[q4];
            byte start = (byte)v5;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v5 >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v5 >> 32);
            }
            buf[pos] = (char)(v5 >> 48);
            IOUtils.putInt(buf, pos + 1, (int)(v4 >> 16));
            IOUtils.putLong(buf, pos + 3, v3 & 0xFFFFFFFFFFFF0000L | v4 >> 48);
            IOUtils.putInt(buf, pos + 7, (int)(v2 >> 16));
            IOUtils.putLong(buf, pos + 9, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
            return pos + 13;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        long v5 = DIGITS_K_64[r5];
        if (q6 == 0) {
            int v = DIGITS_K_32[q5];
            byte start = (byte)v;
            if (start == 0) {
                buf[pos] = (char)(v >> 8);
                buf[pos + 1] = (char)(v >> 16);
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 16);
            }
            buf[pos++] = (char)(v >> 24);
        } else {
            IOUtils.putLong(buf, pos, DIGITS_K_64[q5 - q6 * 1000]);
            buf[pos] = (char)(q6 + 48);
            pos += 4;
        }
        IOUtils.putInt(buf, pos, (int)(v5 >> 16));
        IOUtils.putLong(buf, pos + 2, v4 & 0xFFFFFFFFFFFF0000L | v5 >> 48);
        buf[pos + 6] = (char)(v3 >> 16);
        IOUtils.putLong(buf, pos + 7, (v2 & 0xFFFFFFFF0000L) << 16 | v3 >> 32);
        IOUtils.putLong(buf, pos + 11, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
        return pos + 15;
    }

    public static int writeInt32(byte[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_BYTES, 0, buf, pos, MIN_INT_BYTES.length);
                return pos + MIN_INT_BYTES.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000) {
            int v = DIGITS_K_32[i];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putShort(buf, pos, (short)(v >> 8));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 16);
            }
            buf[pos] = (byte)(v >> 24);
            return pos + 1;
        }
        int q1 = i / 1000;
        int r1 = i - q1 * 1000;
        int v1 = DIGITS_K_32[r1];
        if (i < 1000000) {
            int v2 = DIGITS_K_32[q1];
            byte start = (byte)v2;
            if (start == 0) {
                IOUtils.putShort(buf, pos, (short)(v2 >> 8));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v2 >> 16);
            }
            IOUtils.putInt(buf, pos, v1 & 0xFFFFFF00 | v2 >> 24);
            return pos + 4;
        }
        int q2 = q1 / 1000;
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        int v2 = DIGITS_K_32[r2];
        if (q3 == 0) {
            int v = DIGITS_K_32[q2];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putShort(buf, pos, (short)(v >> 8));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (byte)(v >> 16);
            }
            buf[pos++] = (byte)(v >> 24);
        } else {
            IOUtils.putInt(buf, pos, DIGITS_K_32[q2 - q3 * 1000] & 0xFFFFFF00 | q3 + 48);
            pos += 4;
        }
        IOUtils.putShort(buf, pos, (short)(v2 >> 8));
        IOUtils.putInt(buf, pos + 2, v1 & 0xFFFFFF00 | v2 >> 24);
        return pos + 6;
    }

    public static int writeInt32(char[] buf, int pos, int value) {
        int i;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT_CHARS, 0, buf, pos, MIN_INT_CHARS.length);
                return pos + MIN_INT_CHARS.length;
            }
            i = -value;
            buf[pos++] = 45;
        } else {
            i = value;
        }
        if (i < 1000) {
            long v = DIGITS_K_64[i];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 32);
            }
            buf[pos] = (char)(v >> 48);
            return pos + 1;
        }
        int q1 = i / 1000;
        int r1 = i - q1 * 1000;
        long v1 = DIGITS_K_64[r1];
        if (i < 1000000) {
            long v2 = DIGITS_K_64[q1];
            byte start = (byte)v2;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v2 >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v2 >> 32);
            }
            IOUtils.putLong(buf, pos, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
            return pos + 4;
        }
        int q2 = q1 / 1000;
        int r2 = q1 - q2 * 1000;
        int q3 = q2 / 1000;
        long v2 = DIGITS_K_64[r2];
        if (q3 == 0) {
            long v = DIGITS_K_64[q2];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putInt(buf, pos, (int)(v >> 16));
                pos += 2;
            } else if (start == 1) {
                buf[pos++] = (char)(v >> 32);
            }
            buf[pos++] = (char)(v >> 48);
        } else {
            IOUtils.putLong(buf, pos, DIGITS_K_64[q2 - q3 * 1000]);
            buf[pos] = (char)(q3 + 48);
            pos += 4;
        }
        IOUtils.putInt(buf, pos, (int)(v2 >> 16));
        IOUtils.putLong(buf, pos + 2, v1 & 0xFFFFFFFFFFFF0000L | v2 >> 48);
        return pos + 6;
    }

    public static void putShort(byte[] buf, int pos, short v) {
        JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, JDKUtils.BIG_ENDIAN ? Short.reverseBytes(v) : v);
    }

    public static void putInt(byte[] buf, int pos, int v) {
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, JDKUtils.BIG_ENDIAN ? Integer.reverseBytes(v) : v);
    }

    public static void putInt(char[] buf, int pos, int v) {
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(pos << 1), JDKUtils.BIG_ENDIAN ? Integer.reverseBytes(v) : v);
    }

    public static void putLong(char[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(pos << 1), JDKUtils.BIG_ENDIAN ? Long.reverseBytes(v) : v);
    }

    static {
        int i;
        NULL_32 = JDKUtils.BIG_ENDIAN ? 1853189228 : 1819047278;
        NULL_64 = JDKUtils.BIG_ENDIAN ? 30962749956423788L : 30399761348886638L;
        TRUE = JDKUtils.BIG_ENDIAN ? 1953658213 : 1702195828;
        TRUE_64 = JDKUtils.BIG_ENDIAN ? 32651586932375653L : 28429475166421108L;
        ALSE = JDKUtils.BIG_ENDIAN ? 1634497381 : 1702063201;
        ALSE_64 = JDKUtils.BIG_ENDIAN ? 27303536604938341L : 28429466576093281L;
        DOT_X0 = JDKUtils.BIG_ENDIAN ? 11776L : 46L;
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        DIGITS_K_32 = new int[1000];
        DIGITS_K_64 = new long[1000];
        MIN_INT_BYTES = "-2147483648".getBytes();
        MIN_INT_CHARS = "-2147483648".toCharArray();
        MIN_LONG = "-9223372036854775808".getBytes();
        POWER_TEN = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        short[] shorts = new short[]{12336, 12592, 12848, 13104, 13360, 13616, 13872, 14128, 14384, 14640, 12337, 12593, 12849, 13105, 13361, 13617, 13873, 14129, 14385, 14641, 12338, 12594, 12850, 13106, 13362, 13618, 13874, 14130, 14386, 14642, 12339, 12595, 12851, 13107, 13363, 13619, 13875, 14131, 14387, 14643, 12340, 12596, 12852, 13108, 13364, 13620, 13876, 14132, 14388, 14644, 12341, 12597, 12853, 13109, 13365, 13621, 13877, 14133, 14389, 14645, 12342, 12598, 12854, 13110, 13366, 13622, 13878, 14134, 14390, 14646, 12343, 12599, 12855, 13111, 13367, 13623, 13879, 14135, 14391, 14647, 12344, 12600, 12856, 13112, 13368, 13624, 13880, 14136, 14392, 14648, 12345, 12601, 12857, 13113, 13369, 13625, 13881, 14137, 14393, 14649};
        int[] digits = new int[]{0x300030, 0x310030, 0x320030, 0x330030, 0x340030, 0x350030, 0x360030, 0x370030, 0x380030, 0x390030, 0x300031, 0x310031, 3276849, 0x330031, 3407921, 3473457, 3538993, 3604529, 3670065, 3735601, 0x300032, 3211314, 0x320032, 0x330032, 3407922, 3473458, 3538994, 3604530, 3670066, 3735602, 0x300033, 0x310033, 0x320033, 0x330033, 0x340033, 0x350033, 0x360033, 0x370033, 0x380033, 0x390033, 0x300034, 3211316, 3276852, 0x330034, 0x340034, 3473460, 3538996, 3604532, 3670068, 3735604, 0x300035, 3211317, 3276853, 0x330035, 3407925, 0x350035, 3538997, 3604533, 3670069, 3735605, 0x300036, 3211318, 3276854, 0x330036, 3407926, 3473462, 0x360036, 3604534, 3670070, 3735606, 0x300037, 3211319, 3276855, 0x330037, 3407927, 3473463, 3538999, 0x370037, 3670071, 3735607, 0x300038, 3211320, 3276856, 0x330038, 3407928, 3473464, 3539000, 3604536, 0x380038, 3735608, 0x300039, 3211321, 3276857, 0x330039, 3407929, 3473465, 3539001, 3604537, 3670073, 0x390039};
        if (JDKUtils.BIG_ENDIAN) {
            for (i = 0; i < shorts.length; ++i) {
                shorts[i] = Short.reverseBytes(shorts[i]);
            }
            for (i = 0; i < digits.length; ++i) {
                digits[i] = Integer.reverseBytes(digits[i] << 8);
            }
        }
        PACKED_DIGITS = shorts;
        PACKED_DIGITS_UTF16 = digits;
        for (i = 0; i < 1000; ++i) {
            int c0 = i < 10 ? 2 : (i < 100 ? 1 : 0);
            int c1 = i / 100 + 48;
            int c2 = i / 10 % 10 + 48;
            int c3 = i % 10 + 48;
            IOUtils.DIGITS_K_32[i] = c0 + (c1 << 8) + (c2 << 16) + (c3 << 24);
            long v = (long)(c1 << 16) + ((long)c2 << 32) + ((long)c3 << 48);
            if (JDKUtils.BIG_ENDIAN) {
                v <<= 8;
            }
            IOUtils.DIGITS_K_64[i] = (long)c0 + v;
        }
    }
}

