/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.BiConsumer;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.schema.JSONSchema;
import shade.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderBoolFunc<T, V>
extends FieldReader<T> {
    final BiConsumer<T, V> function;

    FieldReaderBoolFunc(String fieldName, Class<V> fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, BiConsumer<T, V> function) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, null);
        this.function = function;
    }

    @Override
    public void accept(T object, Object value) {
        Boolean booleanValue = TypeUtils.toBoolean(value);
        if (this.schema != null) {
            this.schema.validate(booleanValue);
        }
        this.function.accept(object, booleanValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Boolean fieldValue;
        try {
            fieldValue = jsonReader.readBool();
        }
        catch (Exception e) {
            if ((jsonReader.features(this.features) & JSONReader.Feature.NullOnError.mask) != 0L) {
                fieldValue = null;
            }
            throw e;
        }
        if (this.schema != null) {
            this.schema.validate(fieldValue);
        }
        this.function.accept(object, fieldValue);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBool();
    }

    @Override
    public BiConsumer getFunction() {
        return this.function;
    }
}

