/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Map;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONFactory;
import shade.com.alibaba.fastjson2.JSONPath;
import shade.com.alibaba.fastjson2.JSONPathSingleName;
import shade.com.alibaba.fastjson2.JSONPathTypedMulti;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import shade.com.alibaba.fastjson2.util.TypeUtils;
import shade.com.alibaba.fastjson2.writer.FieldWriter;
import shade.com.alibaba.fastjson2.writer.ObjectWriter;

class JSONPathTypedMultiNames
extends JSONPathTypedMulti {
    final JSONPath prefix;
    final JSONPath[] namePaths;
    final String[] names;
    final FieldReader[] fieldReaders;
    final ObjectReaderAdapter<Object[]> objectReader;

    JSONPathTypedMultiNames(JSONPath[] paths, JSONPath prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, types, formats, pathFeatures, zoneId, features);
        this.prefix = prefix;
        this.namePaths = namePaths;
        this.names = new String[paths.length];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String fieldName;
            JSONPathSingleName jsonPathSingleName = (JSONPathSingleName)namePaths[i2];
            this.names[i2] = fieldName = jsonPathSingleName.name;
        }
        long[] fieldReaderFeatures = new long[this.names.length];
        if (pathFeatures != null) {
            for (int i3 = 0; i3 < pathFeatures.length; ++i3) {
                if ((pathFeatures[i3] & JSONPath.Feature.NullOnError.mask) == 0L) continue;
                int n = i3;
                fieldReaderFeatures[n] = fieldReaderFeatures[n] | JSONReader.Feature.NullOnError.mask;
            }
        }
        Type[] fieldTypes = (Type[])types.clone();
        for (int i4 = 0; i4 < fieldTypes.length; ++i4) {
            Type fieldType = fieldTypes[i4];
            if (fieldType == Boolean.TYPE) {
                fieldTypes[i4] = Boolean.class;
                continue;
            }
            if (fieldType == Character.TYPE) {
                fieldTypes[i4] = Character.class;
                continue;
            }
            if (fieldType == Byte.TYPE) {
                fieldTypes[i4] = Byte.class;
                continue;
            }
            if (fieldType == Short.TYPE) {
                fieldTypes[i4] = Short.class;
                continue;
            }
            if (fieldType == Integer.TYPE) {
                fieldTypes[i4] = Integer.class;
                continue;
            }
            if (fieldType == Long.TYPE) {
                fieldTypes[i4] = Long.class;
                continue;
            }
            if (fieldType == Float.TYPE) {
                fieldTypes[i4] = Float.class;
                continue;
            }
            if (fieldType != Double.TYPE) continue;
            fieldTypes[i4] = Double.class;
        }
        int length = this.names.length;
        this.objectReader = (ObjectReaderAdapter)JSONFactory.getDefaultObjectReaderProvider().createObjectReader(this.names, fieldTypes, fieldReaderFeatures, () -> new Object[length], (o, i, v) -> {
            o[i] = v;
        });
        this.fieldReaders = this.objectReader.getFieldReaders();
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public Object eval(Object root) {
        Object[] array = new Object[this.paths.length];
        Object object = root;
        if (this.prefix != null) {
            object = this.prefix.eval(root);
        }
        if (object == null) {
            return new Object[this.paths.length];
        }
        if (object instanceof Map) {
            return this.objectReader.createInstance((Map)object, 0L);
        }
        ObjectWriter objectReader = JSONFactory.defaultObjectWriterProvider.getObjectWriter(object.getClass());
        for (int i = 0; i < this.names.length; ++i) {
            FieldWriter fieldWriter = objectReader.getFieldWriter(this.names[i]);
            if (fieldWriter == null) continue;
            Object result = fieldWriter.getFieldValue(object);
            Type type = this.types[i];
            if (result != null && result.getClass() != type) {
                result = type == Long.class ? TypeUtils.toLong(result) : (type == BigDecimal.class ? TypeUtils.toBigDecimal(result) : (type == String[].class ? TypeUtils.toStringArray(result) : TypeUtils.cast(result, type)));
            }
            array[i] = result;
        }
        return array;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (this.prefix != null) {
            Object object = jsonReader.readAny();
            return this.eval(object);
        }
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        return this.objectReader.readObject(jsonReader, null, null, 0L);
    }
}

