/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiFunction;
import shade.com.alibaba.fastjson2.JSONArray;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONPath;
import shade.com.alibaba.fastjson2.JSONPathSegment;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.util.IOUtils;
import shade.com.alibaba.fastjson2.util.JDKUtils;

final class JSONPathSegmentIndex
extends JSONPathSegment {
    static final JSONPathSegmentIndex ZERO = new JSONPathSegmentIndex(0);
    static final JSONPathSegmentIndex ONE = new JSONPathSegmentIndex(1);
    static final JSONPathSegmentIndex TWO = new JSONPathSegmentIndex(2);
    static final JSONPathSegmentIndex LAST = new JSONPathSegmentIndex(-1);
    final int index;

    public JSONPathSegmentIndex(int index) {
        this.index = index;
    }

    static JSONPathSegmentIndex of(int index) {
        if (index == 0) {
            return ZERO;
        }
        if (index == 1) {
            return ONE;
        }
        if (index == 2) {
            return TWO;
        }
        if (index == -1) {
            return LAST;
        }
        return new JSONPathSegmentIndex(index);
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            context.eval = true;
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    context.value = list.get(this.index);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0 && itemIndex < list.size()) {
                    context.value = list.get(itemIndex);
                }
            }
            context.eval = true;
            return;
        }
        if (object instanceof SortedSet || object instanceof LinkedHashSet || this.index == 0 && object instanceof Collection && ((Collection)object).size() == 1) {
            Collection collection = (Collection)object;
            int i = 0;
            for (Object item : collection) {
                if (i == this.index) {
                    context.value = item;
                    break;
                }
                ++i;
            }
            context.eval = true;
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    context.value = array[this.index];
                }
            } else {
                int itemIndex = array.length + this.index;
                if (itemIndex >= 0 && itemIndex < array.length) {
                    context.value = array[itemIndex];
                }
            }
            context.eval = true;
            return;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    context.value = Array.get(object, this.index);
                }
            } else {
                int itemIndex = length + this.index;
                if (itemIndex >= 0 && itemIndex < length) {
                    context.value = Array.get(object, itemIndex);
                }
            }
            context.eval = true;
            return;
        }
        if (object instanceof JSONPath.Sequence) {
            List sequence = ((JSONPath.Sequence)object).values;
            JSONArray values = new JSONArray(sequence.size());
            for (Object o : sequence) {
                context.value = o;
                JSONPath.Context itemContext = new JSONPath.Context(context.path, context, context.current, context.next, context.readerFeatures);
                this.eval(itemContext);
                values.add(itemContext.value);
            }
            context.value = context.next != null ? new JSONPath.Sequence(values) : values;
            context.eval = true;
            return;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            context.value = this.eval((Map)object);
            context.eval = true;
            return;
        }
        if (this.index == 0) {
            context.value = object;
            context.eval = true;
            return;
        }
        throw new JSONException("jsonpath not support operate : " + context.path + ", objectClass" + objectClass.getName());
    }

    private Object eval(Map object) {
        Object value;
        block6: {
            value = object.get(this.index);
            if (value == null) {
                value = object.get(Integer.toString(this.index));
            }
            if (value != null) break block6;
            int size = object.size();
            Iterator it = object.entrySet().iterator();
            if (size == 1 || object instanceof LinkedHashMap || object instanceof SortedMap) {
                for (int i = 0; i <= this.index && i < size && it.hasNext(); ++i) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (entryKey instanceof Long) {
                        if (!entryKey.equals(this.index)) continue;
                        value = entryValue;
                        break;
                    }
                    if (i != this.index) continue;
                    value = entryValue;
                }
            } else {
                for (int i = 0; i <= this.index && i < object.size() && it.hasNext(); ++i) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (!(entryKey instanceof Long) || !entryKey.equals(this.index)) continue;
                    value = entryValue;
                    break;
                }
            }
        }
        return value;
    }

    @Override
    public void set(JSONPath.Context context, Object value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index > list.size()) {
                    for (int i = list.size(); i < this.index; ++i) {
                        list.add(null);
                    }
                }
                if (this.index < list.size()) {
                    list.set(this.index, value);
                } else if (this.index <= list.size()) {
                    list.add(value);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    list.set(itemIndex, value);
                }
            }
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            int length = array.length;
            if (this.index >= 0) {
                if (this.index < length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0 && arrayIndex < length) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        if (object != null && object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    Array.set(object, this.index, value);
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0 && arrayIndex < length) {
                    Array.set(object, arrayIndex, value);
                }
            }
            return;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void setCallback(JSONPath.Context context, BiFunction callback) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    Object value = list.get(this.index);
                    value = callback.apply(object, value);
                    list.set(this.index, value);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    Object value = list.get(itemIndex);
                    value = callback.apply(object, value);
                    list.set(itemIndex, value);
                }
            }
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    Object value = array[this.index];
                    array[this.index] = value = callback.apply(object, value);
                }
            } else {
                int itemIndex = array.length + this.index;
                if (itemIndex >= 0) {
                    Object value = array[itemIndex];
                    array[itemIndex] = value = callback.apply(object, value);
                }
            }
            return;
        }
        if (object != null && object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    Object value = Array.get(object, this.index);
                    value = callback.apply(object, value);
                    Array.set(object, this.index, value);
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0) {
                    Object value = Array.get(object, arrayIndex);
                    value = callback.apply(object, value);
                    Array.set(object, arrayIndex, value);
                }
            }
            return;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean remove(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    list.remove(this.index);
                    return true;
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    list.remove(itemIndex);
                    return true;
                }
            }
            return false;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void setInt(JSONPath.Context context, int value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof int[]) {
            int[] array = (int[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        this.set(context, value);
    }

    @Override
    public void setLong(JSONPath.Context context, long value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof int[]) {
            int[] array = (int[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = (int)value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = (int)value;
                }
            }
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        this.set(context, value);
    }

    @Override
    public void accept(JSONReader jsonReader, JSONPath.Context context) {
        if (context.parent != null && (context.parent.eval || context.parent.current instanceof JSONPathSegment.CycleNameSegment && context.next == null)) {
            this.eval(context);
            return;
        }
        if (jsonReader.jsonb) {
            int itemCnt = jsonReader.startArray();
            for (int i = 0; i < itemCnt; ++i) {
                boolean match;
                boolean bl = match = this.index == i;
                if (match) {
                    if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) break;
                    context.value = jsonReader.readAny();
                    context.eval = true;
                    break;
                }
                jsonReader.skipValue();
            }
            return;
        }
        if (jsonReader.ch == '{') {
            Map<String, Object> object = jsonReader.readObject();
            context.value = this.eval(object);
            context.eval = true;
            return;
        }
        jsonReader.next();
        int i = 0;
        block9: while (jsonReader.ch != '\u001a') {
            boolean match;
            if (jsonReader.ch == ']') {
                jsonReader.next();
                if (i != 0) break;
                context.eval = true;
                break;
            }
            boolean bl = match = this.index == -1 || this.index == i;
            if (!match) {
                jsonReader.skipValue();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                Map<String, Object> val;
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        if (context.next != null && !(context.next instanceof JSONPathSegment.EvalSegment)) break block9;
                        val = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        if (context.next != null && !(context.next instanceof JSONPathSegment.EvalSegment)) break block9;
                        val = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException(jsonReader.info("not support : " + jsonReader.ch));
                    }
                }
                if (this.index == -1) {
                    if (jsonReader.ch == ']') {
                        context.value = val;
                    }
                } else {
                    context.value = val;
                }
            }
            ++i;
        }
    }

    public String toString() {
        int size = this.index < 0 ? IOUtils.stringSize(-this.index) + 1 : IOUtils.stringSize(this.index);
        byte[] bytes = new byte[size + 2];
        bytes[0] = 91;
        IOUtils.getChars(this.index, bytes.length - 1, bytes);
        bytes[bytes.length - 1] = 93;
        String str = JDKUtils.STRING_CREATOR_JDK11 != null ? JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1) : new String(bytes, StandardCharsets.ISO_8859_1);
        return str;
    }
}

